package com.digiwin.dap.middleware.mojo;

import com.digiwin.dap.middleware.ssh.DockerUtils;
import com.digiwin.dap.middleware.ssh.Shell;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

/**
 * 导出镜像文件
 *
 * @author fobgochod
 * @date 2022/2/16 9:17
 */
@Mojo(name = "export")
public class ExportMojo extends AbstractDapMojo {

    @Parameter(property = "exportPath", defaultValue = "doc")
    private String exportPath;

    @Override
    public void execute() throws MojoExecutionException {
        DockerUtils.instance(new Shell(host, port, username, password)).export(imageName, imageTag, exportPath);
    }
}
