//package com.digiwin.dap.middleware.mybatis;
//
//import org.apache.ibatis.cache.CacheKey;
//import org.apache.ibatis.executor.Executor;
//import org.apache.ibatis.mapping.BoundSql;
//import org.apache.ibatis.mapping.MappedStatement;
//import org.apache.ibatis.plugin.*;
//import org.apache.ibatis.session.ResultHandler;
//import org.apache.ibatis.session.RowBounds;
//
//import java.io.BufferedWriter;
//import java.io.File;
//import java.io.FileWriter;
//import java.sql.SQLException;
//import java.util.Arrays;
//import java.util.List;
//import java.util.Properties;
//import java.util.concurrent.atomic.AtomicInteger;
//
//@Intercepts({
//        @Signature(type = Executor.class, method = "query", args = {MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class}),
//        @Signature(type = Executor.class, method = "query", args = {MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class, CacheKey.class, BoundSql.class}),
//})
//public class PartitionInterceptor implements Interceptor {
//
//    private static final AtomicInteger num = new AtomicInteger(1);
//    /**
//     * 需要按租户分区的的表
//     */
//    private static final List<String> partitionTables = Arrays.asList(
//            "statement", "multi_language_resource", "role",
//            "association", "policy", "policyonrole",
//            "sysintenant", "rolecatalog", "orgtype",
//            "usermapping"
//    );
//
//
//    private static void write(String content) {
//        try {
//            File file = new File("F:\\partition_result.sql");
//            if (!file.exists()) {
//                file.createNewFile();
//            }
//            FileWriter fw = new FileWriter(file.getAbsoluteFile(), true);
//            BufferedWriter bw = new BufferedWriter(fw);
//            bw.write(content);
//            bw.close();
//        } catch (Exception e) {
//            e.printStackTrace();
//        }
//    }
//
//    private static int tableCount(String sql) {
//        int count = 0;
//        for (String table : partitionTables) {
//            if (sql.contains(" " + table + " ")) {
//                count++;
//            }
//        }
//        return count;
//    }
//
//    private static int condCount(String sql) {
//        String condStr = ".tenant_sid = ";
//
//        int oldCount = sql.length();
//        // 将 ab 替换为空之后字符串的长度
//        int newCount = sql.replace(condStr, "").length();
//        // 由于统计的字符串长度是2，所以出现的次数要除以要统计字符串的长度
//        return (oldCount - newCount) / condStr.length();
//    }
//
//    public void checkPartition(String id, String sql) throws SQLException {
//        String lowerSql = sql.toLowerCase();
//        if (tableCount(lowerSql) > condCount(lowerSql)) {
//            write(num.getAndIncrement() + ". " + id + "\n");
//            write(sql + "\n\n");
//        }
////        for (String table : partitionTables) {
////            if (lowerSql.contains(" " + table + " ") && !lowerSql.contains(".tenant_sid = ")) {
////                write(num.getAndIncrement() + ". " + sql + "\n\n");
////            }
////        }
//    }
//
//    @Override
//    public Object intercept(Invocation invocation) throws Throwable {
//        Object[] args = invocation.getArgs();
//        MappedStatement ms = (MappedStatement) args[0];
//        Object parameter = args[1];
//        RowBounds rowBounds = (RowBounds) args[2];
//        ResultHandler resultHandler = (ResultHandler) args[3];
//        Executor executor = (Executor) invocation.getTarget();
//        CacheKey cacheKey;
//        BoundSql boundSql;
//        //由于逻辑关系，只会进入一次
//        if (args.length == 4) {
//            //4 个参数时
//            boundSql = ms.getBoundSql(parameter);
//            cacheKey = executor.createCacheKey(ms, parameter, rowBounds, boundSql);
//        } else {
//            //6 个参数时
//            cacheKey = (CacheKey) args[4];
//            boundSql = (BoundSql) args[5];
//        }
//        //sql分区字段检查
//        checkPartition(ms.getId(), boundSql.getSql());
//        //注：下面的方法可以根据自己的逻辑调用多次，在分页插件中，count 和 page 各调用了一次
//        return executor.query(ms, parameter, rowBounds, resultHandler, cacheKey, boundSql);
//    }
//
//    @Override
//    public Object plugin(Object target) {
//        return Plugin.wrap(target, this);
//    }
//
//    @Override
//    public void setProperties(Properties properties) {
//    }
//}
