package com.digiwin.dap.middleware.mybatis.typeHandler;

import com.digiwin.dap.middleware.domain.SafeStorageValue;
import com.digiwin.dap.middleware.util.SecureUtils;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.MappedJdbcTypes;
import org.apache.ibatis.type.MappedTypes;
import org.apache.ibatis.type.TypeHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.function.Function;

/**
 *  需要配置{@link TypeHandler}的扫包路径:
 *  mybatis:
 *      typeHandlersPackage: com.digiwin.dap.middleware.mybatis.typeHandler
 * @author blockWilling
 * @date 2024/4/11 16:48
 * @mail kangjin@digiwin.com
 */

@MappedJdbcTypes(JdbcType.VARCHAR)
@MappedTypes(SafeStorageValue.class)
public class AutoEnAndDecryptTypeHandler implements TypeHandler<SafeStorageValue> {
    private static final Logger logger = LoggerFactory.getLogger(AutoEnAndDecryptTypeHandler.class);
    @Override
    public void setParameter(PreparedStatement ps, int i, SafeStorageValue parameter, JdbcType jdbcType) throws SQLException {
        try {
            String s = this.convertToDatabaseColumn(parameter);
            ps.setString(i, s);
        } catch (Exception e) {
            logger.error("【AutoEnAndDecryptTypeHandler.setParameter】{}", e.getMessage());
        }
    }

    @Override
    public SafeStorageValue getResult(ResultSet rs, String columnName) throws SQLException {
        String rsString = null;
        try {
            rsString = rs.getString(columnName);
            return this.convertToEntityAttribute(rsString);
        } catch (Exception e) {
            logger.error("【AutoEnAndDecryptTypeHandler.getResult】{}", e.getMessage());
            return new SafeStorageValue(rsString);
        }
    }

    @Override
    public SafeStorageValue getResult(ResultSet rs, int columnIndex) throws SQLException {
        String rsString = null;
        try {
            rsString = rs.getString(columnIndex);
            return this.convertToEntityAttribute(rsString);
        } catch (Exception e) {
            logger.error("【AutoEnAndDecryptTypeHandler.getResult】{}", e.getMessage());
            return new SafeStorageValue(rsString);
        }
    }

    @Override
    public SafeStorageValue getResult(CallableStatement cs, int columnIndex) throws SQLException {
        String rsString = null;
        try {
            rsString = cs.getString(columnIndex);
            return this.convertToEntityAttribute(rsString);
        } catch (Exception e) {
            logger.error("【AutoEnAndDecryptTypeHandler.getResult】{}", e.getMessage());
            return new SafeStorageValue(rsString);
        }
    }

    private String convertToDatabaseColumn(SafeStorageValue attribute) {
        Object value = attribute.get();
        String toEncrypt = null;
        if (value instanceof String) {
            toEncrypt = (String) value;
        } else {
            Function<Object, String> toStringFunc = attribute.getToStringFunc();
            if (toStringFunc == null) {
                toEncrypt = value.toString();
            } else {
                toEncrypt = toStringFunc.apply(value);
            }
        }
        try {
            return SecureUtils.aesEncrypt(toEncrypt);
        } catch (Exception e) {
            logger.error("【SecureUtils.aesEncrypt】{}", e.getMessage());
            return toEncrypt;
        }
    }

    private SafeStorageValue convertToEntityAttribute(String dbData) {
        String aesDecrypt = null;
        try {
            aesDecrypt = SecureUtils.aesDecrypt(dbData);
        } catch (Exception e) {
            logger.error("【SecureUtils.aesDecrypt】{}", e.getMessage());
            return new SafeStorageValue(dbData);
        }
        //无法声明泛型，因为不知道具体的字段类型
        return new SafeStorageValue(aesDecrypt);
    }
}
