package com.digiwin.dap.middleware.mybatis.typeHandler;

import com.digiwin.dap.middleware.util.SecureUtils;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.TypeHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.annotation.Nullable;
import java.lang.reflect.Field;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

/**
 * @author blockWilling
 * @date 2024/4/11 16:22
 * @mail kangjin@digiwin.com
 * @see StringEnAndDecryptTypeHandler
 */
public class IntegerEnAndDecryptTypeHandler implements TypeHandler<Integer>, DecryptedFieldHandler<Integer> {
    private static final Logger logger = LoggerFactory.getLogger(IntegerEnAndDecryptTypeHandler.class);

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    @Override
    public void setParameter(PreparedStatement ps, int i, Integer parameter, JdbcType jdbcType) throws SQLException {
        try {
            ps.setString(i, SecureUtils.aesEncrypt(String.valueOf(parameter)));
        } catch (Exception e) {
            logger.error("【IntegerEnAndDecryptTypeHandler.setParameter】{}", e.getMessage());
            ps.setString(i, String.valueOf(parameter));
        }
    }

    @Override
    public Integer getResult(ResultSet rs, String columnName) throws SQLException {
        String rsString = null;
        try {
            rsString = rs.getString(columnName);
            return Integer.valueOf(SecureUtils.aesDecrypt(rsString));
        } catch (Exception e) {
            logger.error("【IntegerEnAndDecryptTypeHandler.getResult】{}", e.getMessage());
            return null;
        }
    }

    @Override
    public Integer getResult(ResultSet rs, int columnIndex) throws SQLException {
        String rsString = null;
        try {
            rsString = rs.getString(columnIndex);
            return Integer.valueOf(SecureUtils.aesDecrypt(rsString));
        } catch (Exception e) {
            logger.error("【IntegerEnAndDecryptTypeHandler.getResult】{}", e.getMessage());
            return null;
        }
    }

    @Override
    public Integer getResult(CallableStatement cs, int columnIndex) throws SQLException {
        String rsString = null;
        try {
            rsString = cs.getString(columnIndex);
            return Integer.valueOf(SecureUtils.aesDecrypt(rsString));
        } catch (Exception e) {
            logger.error("【IntegerEnAndDecryptTypeHandler.getResult】{}", e.getMessage());
            return null;
        }
    }

    @Override
    @Nullable
    public Integer handle(String str) {
        try {
            return Integer.valueOf(str);
        } catch (Exception e) {
            logger.error("【IntegerEnAndDecryptTypeHandler.handle】{}", e.getMessage());
            return null;
        }
    }

    @Override
    public boolean support(Field field) {
        return Integer.class.equals(field.getType());
    }
}
