package com.digiwin.dap.middleware.mybatis.typeHandler;

import com.digiwin.dap.middleware.util.SecureUtils;
import org.apache.ibatis.mapping.ResultMap;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.TypeHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.annotation.Nullable;
import java.lang.reflect.Field;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

/**
 * 仅适用mapper的方法出参使用{@link ResultMap}声明<p>
 * example:<p>
 * {@code
 * <resultMap id="XXX" type="com.digiwin.dap.middleware.gmc.entity.Category">
 * <result property="code" column="code" typeHandler="com.digiwin.dap.middleware.gmc.entity.StringEnAndDecryptTypeHandler"/>
 * </resultMap>
 * }
 *
 * @author blockWilling
 * @date 2024/4/11 16:22
 * @mail kangjin@digiwin.com
 */
public class StringEnAndDecryptTypeHandler implements TypeHandler<String>, DecryptedFieldHandler<String> {
    private static final Logger logger = LoggerFactory.getLogger(StringEnAndDecryptTypeHandler.class);

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    @Override
    public void setParameter(PreparedStatement ps, int i, String parameter, JdbcType jdbcType) throws SQLException {
        try {
            ps.setString(i, SecureUtils.aesEncrypt(parameter));
        } catch (Exception e) {
            logger.error("【StringEnAndDecryptTypeHandler.setParameter】{}", e.getMessage());
            ps.setString(i, parameter);
        }
    }

    @Override
    public String getResult(ResultSet rs, String columnName) throws SQLException {
        String rsString = null;
        try {
            rsString = rs.getString(columnName);
            return SecureUtils.aesDecrypt(rsString);
        } catch (Exception e) {
            logger.error("【StringEnAndDecryptTypeHandler.getResult】{}", e.getMessage());
            return rsString;
        }
    }

    @Override
    public String getResult(ResultSet rs, int columnIndex) throws SQLException {
        String rsString = null;
        try {
            rsString = rs.getString(columnIndex);
            return SecureUtils.aesDecrypt(rsString);
        } catch (Exception e) {
            logger.error("【StringEnAndDecryptTypeHandler.getResult】{}", e.getMessage());
            return rsString;
        }
    }

    @Override
    public String getResult(CallableStatement cs, int columnIndex) throws SQLException {
        String rsString = null;
        try {
            rsString = cs.getString(columnIndex);
            return SecureUtils.aesDecrypt(rsString);
        } catch (Exception e) {
            logger.error("【StringEnAndDecryptTypeHandler.getResult】{}", e.getMessage());
            return rsString;
        }
    }

    @Override
    @Nullable
    public String handle(String str) {
        return str;
    }

    @Override
    public boolean support(Field field) {
        return String.class.equals(field.getType());
    }
}
