/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.mybatis;

import cn.hutool.core.util.ReflectUtil;
import com.digiwin.dap.middleware.mybatis.AutoDecrypt;
import com.digiwin.dap.middleware.mybatis.typeHandler.DecryptedFieldHandler;
import com.digiwin.dap.middleware.mybatis.typeHandler.IntegerEnAndDecryptTypeHandler;
import com.digiwin.dap.middleware.mybatis.typeHandler.StringEnAndDecryptTypeHandler;
import com.digiwin.dap.middleware.util.SecureUtils;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.ibatis.cache.CacheKey;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Intercepts(value={@Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class}), @Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class, CacheKey.class, BoundSql.class})})
public class DecryptInterceptor
implements Interceptor {
    private static final int PARAM_COUNT = 4;
    private static final String TMP_FIELD_SUFFIX = "ToDecrypt";
    private static final Logger logger = LoggerFactory.getLogger(DecryptInterceptor.class);
    private Set<DecryptedFieldHandler<?>> set = new HashSet();

    public DecryptInterceptor() {
        this.set.add(new IntegerEnAndDecryptTypeHandler());
        this.set.add(new StringEnAndDecryptTypeHandler());
    }

    public Set<DecryptedFieldHandler<?>> getDecryptedFieldHandlers() {
        return this.set;
    }

    public DecryptInterceptor customizeDecryptedFieldHandlers(Set<DecryptedFieldHandler<?>> set) {
        this.set = set;
        return this;
    }

    public Object intercept(Invocation invocation) throws Throwable {
        CacheKey cacheKey;
        BoundSql boundSql;
        Object[] args = invocation.getArgs();
        MappedStatement ms = (MappedStatement)args[0];
        Object parameter = args[1];
        RowBounds rowBounds = (RowBounds)args[2];
        ResultHandler resultHandler = (ResultHandler)args[3];
        Executor executor = (Executor)invocation.getTarget();
        if (args.length == 4) {
            boundSql = ms.getBoundSql(parameter);
            cacheKey = executor.createCacheKey(ms, parameter, rowBounds, boundSql);
        } else {
            cacheKey = (CacheKey)args[4];
            boundSql = (BoundSql)args[5];
        }
        List ret = executor.query(ms, parameter, rowBounds, resultHandler, cacheKey, boundSql);
        if (ret == null || ret.isEmpty()) {
            return ret;
        }
        try {
            Object first = ret.stream().filter(Objects::nonNull).findFirst().get();
            Class<?> firstClass = first.getClass();
            AutoDecrypt annotation = firstClass.getAnnotation(AutoDecrypt.class);
            if (annotation == null) {
                return ret;
            }
            for (Object o : ret) {
                Field[] fields;
                if (o == null) continue;
                block5: for (Field field : fields = ReflectUtil.getFields(o.getClass())) {
                    field.setAccessible(true);
                    AutoDecrypt annotationField = field.getAnnotation(AutoDecrypt.class);
                    if (annotationField == null) continue;
                    String originalColName = annotationField.originalFieldName();
                    boolean selfLoad = annotationField.selfLoad();
                    if (!String.class.equals(field.getType())) continue;
                    String toDecrypt = (String)field.get(o);
                    Field originalField = null;
                    if (selfLoad) {
                        originalField = field;
                    } else if (originalColName == null || originalColName.isEmpty()) {
                        String name = field.getName();
                        int i = name.indexOf(TMP_FIELD_SUFFIX);
                        if (i == -1 || i == 0) {
                            logger.error("\u89e3\u5bc6\u5b57\u6bb5\u6ce8\u89e3\u914d\u7f6e\u6709\u8bef:{}", (Object)name);
                            continue;
                        }
                        originalColName = name.substring(0, i);
                    }
                    if (originalField == null) {
                        originalField = ReflectUtil.getField(o.getClass(), (String)originalColName);
                    }
                    originalField.setAccessible(true);
                    String decrypt = null;
                    try {
                        decrypt = SecureUtils.aesDecrypt((String)toDecrypt);
                    }
                    catch (Exception e) {
                        logger.error("\u3010SecureUtils.aesDecrypt\u3011{}", (Object)e.getMessage());
                        continue;
                    }
                    for (DecryptedFieldHandler<?> decryptedFieldHandler : this.set) {
                        if (!decryptedFieldHandler.support(originalField)) continue;
                        originalField.set(o, decryptedFieldHandler.handle(decrypt));
                        continue block5;
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error("\u3010DecryptInterceptor\u3011", (Throwable)e);
        }
        return ret;
    }
}

