/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.mybatis.typeHandler;

import com.digiwin.dap.middleware.domain.SafeStorageValue;
import com.digiwin.dap.middleware.util.SecureUtils;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.function.Function;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.MappedJdbcTypes;
import org.apache.ibatis.type.MappedTypes;
import org.apache.ibatis.type.TypeHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MappedJdbcTypes(value={JdbcType.VARCHAR})
@MappedTypes(value={SafeStorageValue.class})
public class AutoEnAndDecryptTypeHandler
implements TypeHandler<SafeStorageValue> {
    private static final Logger logger = LoggerFactory.getLogger(AutoEnAndDecryptTypeHandler.class);

    public void setParameter(PreparedStatement ps, int i, SafeStorageValue parameter, JdbcType jdbcType) throws SQLException {
        try {
            String s = this.convertToDatabaseColumn(parameter);
            ps.setString(i, s);
        }
        catch (Exception e) {
            logger.error("\u3010AutoEnAndDecryptTypeHandler.setParameter\u3011{}", (Object)e.getMessage());
        }
    }

    public SafeStorageValue getResult(ResultSet rs, String columnName) throws SQLException {
        String rsString = null;
        try {
            rsString = rs.getString(columnName);
            return this.convertToEntityAttribute(rsString);
        }
        catch (Exception e) {
            logger.error("\u3010AutoEnAndDecryptTypeHandler.getResult\u3011{}", (Object)e.getMessage());
            return new SafeStorageValue((Object)rsString);
        }
    }

    public SafeStorageValue getResult(ResultSet rs, int columnIndex) throws SQLException {
        String rsString = null;
        try {
            rsString = rs.getString(columnIndex);
            return this.convertToEntityAttribute(rsString);
        }
        catch (Exception e) {
            logger.error("\u3010AutoEnAndDecryptTypeHandler.getResult\u3011{}", (Object)e.getMessage());
            return new SafeStorageValue((Object)rsString);
        }
    }

    public SafeStorageValue getResult(CallableStatement cs, int columnIndex) throws SQLException {
        String rsString = null;
        try {
            rsString = cs.getString(columnIndex);
            return this.convertToEntityAttribute(rsString);
        }
        catch (Exception e) {
            logger.error("\u3010AutoEnAndDecryptTypeHandler.getResult\u3011{}", (Object)e.getMessage());
            return new SafeStorageValue((Object)rsString);
        }
    }

    private String convertToDatabaseColumn(SafeStorageValue attribute) {
        Function toStringFunc;
        Object value = attribute.get();
        String toEncrypt = null;
        toEncrypt = value instanceof String ? (String)value : ((toStringFunc = attribute.getToStringFunc()) == null ? value.toString() : (String)toStringFunc.apply(value));
        try {
            return SecureUtils.aesEncrypt((String)toEncrypt);
        }
        catch (Exception e) {
            logger.error("\u3010SecureUtils.aesEncrypt\u3011{}", (Object)e.getMessage());
            return toEncrypt;
        }
    }

    private SafeStorageValue convertToEntityAttribute(String dbData) {
        String aesDecrypt = null;
        try {
            aesDecrypt = SecureUtils.aesDecrypt((String)dbData);
        }
        catch (Exception e) {
            logger.error("\u3010SecureUtils.aesDecrypt\u3011{}", (Object)e.getMessage());
            return new SafeStorageValue((Object)dbData);
        }
        return new SafeStorageValue((Object)aesDecrypt);
    }
}

