/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.mybatis.typeHandler;

import com.digiwin.dap.middleware.mybatis.typeHandler.DecryptedFieldHandler;
import com.digiwin.dap.middleware.util.SecureUtils;
import java.lang.reflect.Field;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.annotation.Nullable;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.TypeHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StringEnAndDecryptTypeHandler
implements TypeHandler<String>,
DecryptedFieldHandler<String> {
    private static final Logger logger = LoggerFactory.getLogger(StringEnAndDecryptTypeHandler.class);

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public void setParameter(PreparedStatement ps, int i, String parameter, JdbcType jdbcType) throws SQLException {
        try {
            ps.setString(i, SecureUtils.aesEncrypt((String)parameter));
        }
        catch (Exception e) {
            logger.error("\u3010StringEnAndDecryptTypeHandler.setParameter\u3011{}", (Object)e.getMessage());
            ps.setString(i, parameter);
        }
    }

    public String getResult(ResultSet rs, String columnName) throws SQLException {
        String rsString = null;
        try {
            rsString = rs.getString(columnName);
            return SecureUtils.aesDecrypt((String)rsString);
        }
        catch (Exception e) {
            logger.error("\u3010StringEnAndDecryptTypeHandler.getResult\u3011{}", (Object)e.getMessage());
            return rsString;
        }
    }

    public String getResult(ResultSet rs, int columnIndex) throws SQLException {
        String rsString = null;
        try {
            rsString = rs.getString(columnIndex);
            return SecureUtils.aesDecrypt((String)rsString);
        }
        catch (Exception e) {
            logger.error("\u3010StringEnAndDecryptTypeHandler.getResult\u3011{}", (Object)e.getMessage());
            return rsString;
        }
    }

    public String getResult(CallableStatement cs, int columnIndex) throws SQLException {
        String rsString = null;
        try {
            rsString = cs.getString(columnIndex);
            return SecureUtils.aesDecrypt((String)rsString);
        }
        catch (Exception e) {
            logger.error("\u3010StringEnAndDecryptTypeHandler.getResult\u3011{}", (Object)e.getMessage());
            return rsString;
        }
    }

    @Override
    @Nullable
    public String handle(String str) {
        return str;
    }

    @Override
    public boolean support(Field field) {
        return String.class.equals(field.getType());
    }
}

