package com.digiwin.dap.middleware.mybatis.typeHandler;

import com.digiwin.dap.middle.database.encrypt.desensitization.DefaultDesensitizationProcessorRegistry;
import com.digiwin.dap.middle.database.encrypt.desensitization.DesensitizationProcessor;
import com.digiwin.dap.middle.database.encrypt.enums.DesensitizationMode;
import com.digiwin.dap.middleware.util.SpringBeansUtils;
import org.apache.ibatis.type.BaseTypeHandler;
import org.apache.ibatis.type.JdbcType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Objects;

/**
 * @author michael
 * * <p>mybatis自定义TypeHandler,对指定参数进行sha256加密,sha256不可逆所以结果集无需解密</p>
 */
public class Sha256TypeHandler extends BaseTypeHandler<String> {

    private final static Logger LOGGER = LoggerFactory.getLogger(Sha256TypeHandler.class);

    @Override
    public void setNonNullParameter(PreparedStatement ps, int i, String parameter, JdbcType jdbcType) throws SQLException {
        ps.setString(i, desensitize(String.valueOf(i), parameter));
    }

    @Override
    public String getNullableResult(ResultSet rs, String columnName) throws SQLException {
        return rs.getString(columnName);
    }

    @Override
    public String getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
        return rs.getString(columnIndex);
    }

    @Override
    public String getNullableResult(CallableStatement cs, int columnIndex) throws SQLException {
        return cs.getString(columnIndex);
    }

    private String desensitize(String field, String value) {
        try {
            DefaultDesensitizationProcessorRegistry defaultDesensitizationProcessorRegistry = SpringBeansUtils.getBean(DefaultDesensitizationProcessorRegistry.class);
            if (Objects.isNull(defaultDesensitizationProcessorRegistry)) {
                LOGGER.error("===>Sha256TypeHandler desensitize error,processor not found");
                return value;
            }
            DesensitizationProcessor desensitizationProcessor = defaultDesensitizationProcessorRegistry.findDesensitizationProcessor(DesensitizationMode.SHA256);
            LOGGER.debug("===>Sha256TypeHandler desensitize,column name:{}", field);
            return desensitizationProcessor.desensitize(field, value);
        } catch (Exception e) {
            LOGGER.error("===>Sha256TypeHandler desensitize error,column name:{}", field, e);
            return value;
        }
    }
}
