package com.digiwin.dap.middleware.mybatis.pagehelper;

import com.github.pagehelper.*;
import com.github.pagehelper.dialect.AbstractDialect;
import com.github.pagehelper.util.StringUtil;
import org.apache.ibatis.cache.CacheKey;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.session.RowBounds;

import java.util.Properties;


/**
 * 添加支持自定义是否进行count查询和count sql形式
 *
 * @author blockWilling
 * @date 2024/1/2 10:26
 * @mail kangjin@digiwin.com
 */
public class CustomDialect extends PageHelper {
    private CustomCountSqlParser countSqlParser = null;
    public CustomDialect() {

    }

    @Override
    public boolean beforeCount(MappedStatement ms, Object parameterObject, RowBounds rowBounds) {
        return CustomPageSettingsHolder.isCount() && super.beforeCount(ms, parameterObject, rowBounds);
    }

    @Override
    public String getCountSql(MappedStatement ms, BoundSql boundSql, Object parameterObject, RowBounds rowBounds, CacheKey countKey) {
        Page<Object> page = getLocalPage();
        String countColumn = page.getCountColumn();
        if (StringUtil.isNotEmpty(countColumn)) {
            return countSqlParser.getSmartCountSql(boundSql.getSql(), countColumn);
        }
        return countSqlParser.getSmartCountSql(boundSql.getSql());
    }

    @Override
    public void afterAll() {
        super.afterAll();
        CustomPageSettingsHolder.clear();
    }

    /**
     * {@link AbstractDialect#setProperties(Properties)}
     * @param properties
     */
    @Override
    public void setProperties(Properties properties) {
        super.setProperties(properties);
        String sqlParser = properties.getProperty("sqlParser");
        JSqlParser jSqlParser=null;
        if (StringUtil.isNotEmpty(sqlParser)) {
            try {
                Class<?> aClass = Class.forName(sqlParser);
                jSqlParser = (JSqlParser)aClass.newInstance();
                if (jSqlParser instanceof PageProperties) {
                    ((PageProperties)jSqlParser).setProperties(properties);
                }
            } catch (Exception var4) {
                throw new PageException(var4);
            }
        } else {
            jSqlParser = JSqlParser.DEFAULT;
        }
        countSqlParser = new CustomCountSqlParser(jSqlParser);
    }
}
