/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.mybatis.typeHandler;

import com.digiwin.dap.middle.database.encrypt.desensitization.processor.DesensitizationProcessor;
import com.digiwin.dap.middle.database.encrypt.desensitization.register.DesensitizationProcessorRegistry;
import com.digiwin.dap.middle.database.encrypt.enums.DesensitizationModeEnum;
import com.digiwin.dap.middleware.util.SpringBeansUtils;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Objects;
import org.apache.ibatis.type.BaseTypeHandler;
import org.apache.ibatis.type.JdbcType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Sha256TypeHandler
extends BaseTypeHandler<String> {
    private static final Logger LOGGER = LoggerFactory.getLogger(Sha256TypeHandler.class);

    public void setNonNullParameter(PreparedStatement ps, int i, String parameter, JdbcType jdbcType) throws SQLException {
        ps.setString(i, this.desensitize(String.valueOf(i), parameter));
    }

    public String getNullableResult(ResultSet rs, String columnName) throws SQLException {
        return rs.getString(columnName);
    }

    public String getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
        return rs.getString(columnIndex);
    }

    public String getNullableResult(CallableStatement cs, int columnIndex) throws SQLException {
        return cs.getString(columnIndex);
    }

    private String desensitize(String field, String value) {
        try {
            DesensitizationProcessorRegistry desensitizationProcessorRegistry = (DesensitizationProcessorRegistry)SpringBeansUtils.getBean(DesensitizationProcessorRegistry.class);
            if (Objects.isNull(desensitizationProcessorRegistry)) {
                LOGGER.error("===>Sha256TypeHandler desensitize error,processor not found");
                return value;
            }
            DesensitizationProcessor desensitizationProcessor = desensitizationProcessorRegistry.findDesensitizationProcessor(DesensitizationModeEnum.SHA256);
            LOGGER.debug("===>Sha256TypeHandler desensitize,column name:{}", (Object)field);
            return desensitizationProcessor.desensitize("", field, value);
        }
        catch (Exception e) {
            LOGGER.error("===>Sha256TypeHandler desensitize error,column name:{}", (Object)field, (Object)e);
            return value;
        }
    }
}

