/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.mybatis;

import com.alibaba.druid.wall.Violation;
import com.alibaba.druid.wall.WallCheckResult;
import com.alibaba.druid.wall.WallConfig;
import com.alibaba.druid.wall.WallProvider;
import com.alibaba.druid.wall.spi.MySqlWallProvider;
import com.alibaba.druid.wall.violation.SyntaxErrorViolation;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.ibatis.cache.CacheKey;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;

@Intercepts(value={@Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class}), @Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class, CacheKey.class, BoundSql.class})})
public class InjectionInterceptor
implements Interceptor {
    private static final WallProvider provider;
    private static final String ORDER_BY = "orderBy";
    private static final String SQL_PATTERN = "[a-zA-Z0-9_\\ \\,\\.]+";

    public void checkInjection(Object parameter, String sql) throws SQLException {
        WallCheckResult checkResult;
        List violations;
        Map parameters;
        if (parameter instanceof Map && (parameters = (Map)parameter).containsKey(ORDER_BY)) {
            boolean matches;
            String value;
            String string = value = parameters.get(ORDER_BY) == null ? "" : parameters.get(ORDER_BY).toString();
            if (!value.isEmpty() && !(matches = value.matches(SQL_PATTERN))) {
                throw new SQLException("sql injection violation, " + value + " : " + sql);
            }
        }
        if ((violations = (checkResult = provider.check(sql)).getViolations()).size() > 0) {
            Violation firstViolation = (Violation)violations.get(0);
            if (violations.get(0) instanceof SyntaxErrorViolation) {
                SyntaxErrorViolation violation = (SyntaxErrorViolation)violations.get(0);
                throw new SQLException("sql injection violation, " + firstViolation.getMessage() + " : " + sql, violation.getException());
            }
            throw new SQLException("sql injection violation, " + firstViolation.getMessage() + " : " + sql);
        }
    }

    public Object intercept(Invocation invocation) throws Throwable {
        CacheKey cacheKey;
        BoundSql boundSql;
        Object[] args = invocation.getArgs();
        MappedStatement ms = (MappedStatement)args[0];
        Object parameter = args[1];
        RowBounds rowBounds = (RowBounds)args[2];
        ResultHandler resultHandler = (ResultHandler)args[3];
        Executor executor = (Executor)invocation.getTarget();
        if (args.length == 4) {
            boundSql = ms.getBoundSql(parameter);
            cacheKey = executor.createCacheKey(ms, parameter, rowBounds, boundSql);
        } else {
            cacheKey = (CacheKey)args[4];
            boundSql = (BoundSql)args[5];
        }
        this.checkInjection(parameter, boundSql.getSql());
        return executor.query(ms, parameter, rowBounds, resultHandler, cacheKey, boundSql);
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
    }

    static {
        WallConfig config = new WallConfig("META-INF/druid/wall/mysql");
        config.setSelectWhereAlwayTrueCheck(false);
        config.setConditionAndAlwayTrueAllow(true);
        provider = new MySqlWallProvider(config);
    }
}

