package com.digiwin.dap.middleware.mybatis.config;

import com.alibaba.druid.wall.WallConfig;
import com.alibaba.druid.wall.spi.MySqlWallProvider;
import com.digiwin.dap.middle.kms.constants.KeyConstant;
import com.digiwin.dap.middleware.mybatis.interceptor.InjectionInterceptor;
import com.github.pagehelper.PageInterceptor;
import org.apache.ibatis.plugin.InterceptorChain;
import org.mybatis.spring.boot.autoconfigure.ConfigurationCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import java.util.Properties;

/**
 * @author michael
 */
@Configuration
public class MyBatisConfig {

    private final static Logger LOGGER = LoggerFactory.getLogger(MyBatisConfig.class);
    private final static String MYBATIS_VARIABLES_AES_KEY = "aesKey";

    /**
     * SQL拦截器，统一注入，方便控制顺序
     *
     * @see InterceptorChain
     * @see ConfigurationCustomizer
     */
    @Bean
    public ConfigurationCustomizer customInterceptor() {
        return configuration -> {
            configuration.addInterceptor(injectionInterceptor());
            configuration.addInterceptor(pageInterceptor());
        };
    }

    /**
     * 将aesKey设置为全局变量
     *
     * @return org.mybatis.spring.boot.autoconfigure.ConfigurationCustomizer
     **/
    @Bean
    public ConfigurationCustomizer customGlobalVariables() {
        Properties properties = new Properties();
        //  此处不可调用KmsService,KmsService加载顺序在mybatis配置初始化之后,直接调用会查询不到值
        properties.setProperty(MYBATIS_VARIABLES_AES_KEY, KeyConstant.DIGIWIN);
        LOGGER.debug("===>MyBatis设定全局参数");
        return configuration -> configuration.setVariables(properties);
    }

    /**
     * 防SQL注入拦截器
     */
    private InjectionInterceptor injectionInterceptor() {
        WallConfig config = new WallConfig(MySqlWallProvider.DEFAULT_CONFIG_DIR);
        config.setConditionAndAlwayFalseAllow(true);
        LOGGER.debug("===>MyBatis防SQL注入拦截器初始化");
        return new InjectionInterceptor(config);
    }

    /**
     * 分页插件拦截器
     */
    private PageInterceptor pageInterceptor() {
        PageInterceptor pageInterceptor = new PageInterceptor();
        Properties properties = new Properties();
        properties.setProperty("helperDialect", "mariadb");
        properties.setProperty("reasonable", "true");
        properties.setProperty("supportMethodsArguments", "true");
        properties.setProperty("params", "count=countSql");
        pageInterceptor.setProperties(properties);
        LOGGER.debug("===>MyBatis分页拦截器初始化");
        return pageInterceptor;
    }
}
