/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.mybatis.config;

import com.alibaba.druid.wall.WallConfig;
import com.digiwin.dap.middle.kms.constants.KeyConstant;
import com.digiwin.dap.middleware.mybatis.interceptor.InjectionInterceptor;
import com.github.pagehelper.PageInterceptor;
import java.util.Properties;
import org.apache.ibatis.plugin.Interceptor;
import org.mybatis.spring.boot.autoconfigure.ConfigurationCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class MyBatisConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(MyBatisConfig.class);
    private static final String MYBATIS_VARIABLES_AES_KEY = "aesKey";

    @Bean
    public ConfigurationCustomizer customInterceptor() {
        return configuration -> {
            configuration.addInterceptor((Interceptor)this.injectionInterceptor());
            configuration.addInterceptor((Interceptor)this.pageInterceptor());
        };
    }

    @Bean
    public ConfigurationCustomizer customGlobalVariables() {
        Properties properties = new Properties();
        properties.setProperty(MYBATIS_VARIABLES_AES_KEY, KeyConstant.DIGIWIN);
        LOGGER.debug("===>MyBatis\u8bbe\u5b9a\u5168\u5c40\u53c2\u6570");
        return configuration -> configuration.setVariables(properties);
    }

    private InjectionInterceptor injectionInterceptor() {
        WallConfig config = new WallConfig("META-INF/druid/wall/mysql");
        config.setConditionAndAlwayFalseAllow(true);
        LOGGER.debug("===>MyBatis\u9632SQL\u6ce8\u5165\u62e6\u622a\u5668\u521d\u59cb\u5316");
        return new InjectionInterceptor(config);
    }

    private PageInterceptor pageInterceptor() {
        PageInterceptor pageInterceptor = new PageInterceptor();
        Properties properties = new Properties();
        properties.setProperty("helperDialect", "mariadb");
        properties.setProperty("reasonable", "true");
        properties.setProperty("supportMethodsArguments", "true");
        properties.setProperty("params", "count=countSql");
        pageInterceptor.setProperties(properties);
        LOGGER.debug("===>MyBatis\u5206\u9875\u62e6\u622a\u5668\u521d\u59cb\u5316");
        return pageInterceptor;
    }
}

