/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.mybatis.interceptor;

import com.digiwin.dap.middle.database.encrypt.desensitization.context.DesensitizationConvertContext;
import com.digiwin.dap.middle.database.encrypt.desensitization.service.DesensitizationConverter;
import com.digiwin.dap.middle.database.encrypt.sql.parser.SqlParser;
import com.digiwin.dap.middleware.commons.util.StrUtils;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.regex.Pattern;
import org.apache.ibatis.cache.CacheKey;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ResultMap;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Intercepts(value={@Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class}), @Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class, CacheKey.class, BoundSql.class})})
public class DecryptResultInterceptor
implements Interceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(DecryptResultInterceptor.class);
    private static final Pattern UNION_PATTERN = Pattern.compile("\\s+UNION(?:\\s+ALL)?\\s+", 2);
    private final DesensitizationConverter<Object> desensitizationConverter;
    private final SqlParser sqlParser;

    public DecryptResultInterceptor(DesensitizationConverter<Object> desensitizationConverter, SqlParser sqlParser) {
        this.desensitizationConverter = desensitizationConverter;
        this.sqlParser = sqlParser;
    }

    public Object intercept(Invocation invocation) throws InvocationTargetException, IllegalAccessException {
        Object result = invocation.proceed();
        String targetMethod = "";
        try {
            MappedStatement mappedStatement = (MappedStatement)invocation.getArgs()[0];
            if (mappedStatement.getResultMaps() != null && !mappedStatement.getResultMaps().isEmpty() && ((ResultMap)mappedStatement.getResultMaps().get(0)).getResultMappings() != null && !((ResultMap)mappedStatement.getResultMaps().get(0)).getResultMappings().isEmpty()) {
                return result;
            }
            Object[] args = invocation.getArgs();
            targetMethod = mappedStatement.getId();
            String sql = mappedStatement.getBoundSql(args[1]).getSql();
            String[] sqlList = UNION_PATTERN.split(sql);
            ArrayList objectRelationalMappingList = new ArrayList();
            for (String sqlStr : sqlList) {
                objectRelationalMappingList.addAll(this.sqlParser.parseQuerySql(targetMethod, sqlStr));
            }
            DesensitizationConvertContext resultContext = new DesensitizationConvertContext(targetMethod, objectRelationalMappingList);
            resultContext.setContext(result);
            return this.desensitizationConverter.revert(resultContext);
        }
        catch (Exception e) {
            Object errorMsg = StrUtils.isNotEmpty((String)targetMethod) ? targetMethod + "\u65b9\u6cd5\u5bf9\u7ed3\u679c\u96c6\u89e3\u5bc6\u5931\u8d25" : "mybatis\u89e3\u5bc6\u7ed3\u679c\u96c6\u5f02\u5e38";
            LOGGER.error("===>{}", errorMsg, (Object)e);
            return result;
        }
    }

    public Object plugin(Object target) {
        return super.plugin(target);
    }

    public void setProperties(Properties properties) {
        super.setProperties(properties);
    }
}

