package com.digiwin.dap.middle.autoconfigure.config;

import com.digiwin.dap.middle.autoconfigure.properties.RamProperties;
import com.digiwin.dap.middle.ram.constant.Constant;
import com.digiwin.dap.middle.ram.filter.AfterAuthenticationFilter;
import com.digiwin.dap.middle.ram.filter.BeforeAuthenticationFilter;
import com.digiwin.dap.middle.ram.filter.CheckAppAuthenticationFilter;
import com.digiwin.dap.middle.ram.interceptor.PreHandleInterceptor;
import com.digiwin.dap.middle.ram.mapper.RamPolicyMapper;
import com.digiwin.dap.middle.ram.service.CheckAppAuthService;
import com.digiwin.dap.middle.ram.service.PolicyQueryService;
import com.digiwin.dap.middle.ram.service.executor.*;
import com.digiwin.dap.middle.ram.service.policy.filiter.*;
import com.digiwin.dap.middle.ram.service.policy.interceptor.FunctionPolicyInterceptorHandler;
import com.digiwin.dap.middle.ram.service.policy.interceptor.MergePolicyInterceptorHandler;
import com.digiwin.dap.middle.ram.service.policy.interceptor.PolicyInterceptorHandler;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.web.servlet.handler.MappedInterceptor;

import javax.servlet.Filter;
import java.util.ArrayList;
import java.util.List;

/**
 * 包扫描
 *
 * @author Seven
 * @date 2021/8/20 11:45
 */
@Configuration
@ComponentScan(basePackages = "com.digiwin.dap.middle.ram")
@MapperScan("com.digiwin.dap.middle.ram.mapper")
@EnableConfigurationProperties(RamProperties.class)
public class RamScanConfiguration {

    private final RamProperties properties;

    public RamScanConfiguration(RamProperties properties) {
        this.properties = properties;
    }

    @Bean
    public GrantExecutor grantExecutor(RamPolicyMapper ramPolicyMapper) {
        GrantExecutor grantExecutor = new GrantSimpleExecutor(ramPolicyMapper);
        if (properties.isCache()) {
            grantExecutor = new GrantCachingExecutor(grantExecutor);
        }
        return grantExecutor;
    }

    @Bean
    public PolicyExecutor policyExecutor(RamPolicyMapper ramPolicyMapper) {
        PolicyExecutor policyExecutor = new PolicySimpleExecutor(ramPolicyMapper);
        if (properties.isCache()) {
            policyExecutor = new PolicyCachingExecutor(policyExecutor);
        }
        return policyExecutor;
    }

    @Bean
    @ConditionalOnBean(PolicyQueryService.class)
    @ConditionalOnMissingBean(name = "beforeAuthenticationFilter")
    @ConditionalOnProperty(prefix = "dap.middleware.ram", value = "obsolete", havingValue = "true", matchIfMissing = true)
    public FilterRegistrationBean<Filter> beforeAuthenticationFilter(PolicyQueryService policyQueryService) {
        List<PolicyFilterHandler> policyHandlers = new ArrayList<>();
        policyHandlers.add(new NonePolicyFilterHandler(policyQueryService));
        policyHandlers.add(new ObsoletePolicyFilterHandler(policyQueryService));
        AnnotationAwareOrderComparator.sort(policyHandlers);

        FilterRegistrationBean<Filter> registrationBean = new FilterRegistrationBean<>();
        registrationBean.setFilter(new BeforeAuthenticationFilter(policyHandlers));
        registrationBean.setOrder(-101);
        registrationBean.addUrlPatterns(Constant.DEFAULT_URL_MAPPINGS);
        registrationBean.setAsyncSupported(true);
        return registrationBean;
    }

    @Bean
    @ConditionalOnBean(value = PolicyQueryService.class)
    @ConditionalOnMissingBean(name = "afterAuthenticationFilter")
    public FilterRegistrationBean<Filter> afterAuthenticationFilter(PolicyQueryService policyQueryService) {
        List<PolicyFilterHandler> policyHandlers = new ArrayList<>();
        policyHandlers.add(new AllowListPolicyFilterHandler(policyQueryService));
        policyHandlers.add(new BlockListPolicyFilterHandler());
        policyHandlers.add(new BasePolicyFilterHandler(policyQueryService));
        AnnotationAwareOrderComparator.sort(policyHandlers);

        FilterRegistrationBean<Filter> registrationBean = new FilterRegistrationBean<>();
        registrationBean.setFilter(new AfterAuthenticationFilter(policyHandlers));
        registrationBean.setOrder(-99);
        registrationBean.addUrlPatterns(Constant.DEFAULT_URL_MAPPINGS);
        registrationBean.setAsyncSupported(true);
        return registrationBean;
    }

    @Bean
    @ConditionalOnBean(value = {PolicyQueryService.class,CheckAppAuthService.class})
    @ConditionalOnMissingBean(name = "checkAppAuthenticationFilter")
    public FilterRegistrationBean<Filter> checkAppAuthenticationFilter(PolicyQueryService policyQueryService,CheckAppAuthService checkAppAuthService) {
        List<PolicyFilterHandler> policyHandlers = new ArrayList<>();
        policyHandlers.add(new CheckAppPolicyFilterHandler(policyQueryService,checkAppAuthService));
        AnnotationAwareOrderComparator.sort(policyHandlers);

        FilterRegistrationBean<Filter> registrationBean = new FilterRegistrationBean<>();
        registrationBean.setFilter(new CheckAppAuthenticationFilter(policyHandlers));
        registrationBean.setOrder(-98);
        registrationBean.addUrlPatterns(Constant.DEFAULT_URL_MAPPINGS);
        registrationBean.setAsyncSupported(true);
        return registrationBean;
    }

    @Bean
    @ConditionalOnBean(PolicyQueryService.class)
    @ConditionalOnMissingBean(name = "preHandleInterceptor")
    public MappedInterceptor preHandleInterceptor(PolicyQueryService policyQueryService) {
        List<PolicyInterceptorHandler> policyHandlers = new ArrayList<>();
        if (properties.isFunction()) {
            policyHandlers.add(new FunctionPolicyInterceptorHandler(policyQueryService));
        }
        policyHandlers.add(new MergePolicyInterceptorHandler());
        AnnotationAwareOrderComparator.sort(policyHandlers);

        PreHandleInterceptor interceptor = new PreHandleInterceptor(policyHandlers);
        return new MappedInterceptor(Constant.DEFAULT_PATH_MAPPINGS, interceptor);
    }
}
