/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middle.autoconfigure.config;

import com.digiwin.dap.middle.autoconfigure.properties.RamProperties;
import com.digiwin.dap.middle.ram.constant.Constant;
import com.digiwin.dap.middle.ram.domain.enums.PolicyType;
import com.digiwin.dap.middle.ram.filter.ResourceAccessManagementFilter;
import com.digiwin.dap.middle.ram.interceptor.ResourceAccessManagementInterceptor;
import com.digiwin.dap.middle.ram.mapper.RamPolicyMapper;
import com.digiwin.dap.middle.ram.service.PolicyQueryService;
import com.digiwin.dap.middle.ram.service.executor.GrantCachingExecutor;
import com.digiwin.dap.middle.ram.service.executor.GrantExecutor;
import com.digiwin.dap.middle.ram.service.executor.GrantSimpleExecutor;
import com.digiwin.dap.middle.ram.service.executor.PolicyCachingExecutor;
import com.digiwin.dap.middle.ram.service.executor.PolicyExecutor;
import com.digiwin.dap.middle.ram.service.executor.PolicySimpleExecutor;
import com.digiwin.dap.middle.ram.service.policy.filiter.AllowListPolicyFilterHandler;
import com.digiwin.dap.middle.ram.service.policy.filiter.BasePolicyFilterHandler;
import com.digiwin.dap.middle.ram.service.policy.filiter.BlockListPolicyFilterHandler;
import com.digiwin.dap.middle.ram.service.policy.filiter.NonePolicyFilterHandler;
import com.digiwin.dap.middle.ram.service.policy.filiter.PolicyFilterHandler;
import com.digiwin.dap.middle.ram.service.policy.interceptor.FunctionPolicyInterceptorHandler;
import com.digiwin.dap.middle.ram.service.policy.interceptor.ObsoletePolicyInterceptorHandler;
import com.digiwin.dap.middle.ram.service.policy.interceptor.PolicyInterceptorHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.servlet.Filter;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.handler.MappedInterceptor;

@Configuration
@ComponentScan(basePackages={"com.digiwin.dap.middle.ram"})
@MapperScan(value={"com.digiwin.dap.middle.ram.mapper"})
@EnableConfigurationProperties(value={RamProperties.class})
public class RamScanConfiguration {
    private final RamProperties properties;

    public RamScanConfiguration(RamProperties properties) {
        this.properties = properties;
    }

    @Bean
    public GrantExecutor grantExecutor(RamPolicyMapper ramPolicyMapper) {
        GrantSimpleExecutor grantExecutor = new GrantSimpleExecutor(ramPolicyMapper);
        if (this.properties.isCache()) {
            grantExecutor = new GrantCachingExecutor((GrantExecutor)grantExecutor);
        }
        return grantExecutor;
    }

    @Bean
    public PolicyExecutor policyExecutor(RamPolicyMapper ramPolicyMapper) {
        PolicySimpleExecutor policyExecutor = new PolicySimpleExecutor(ramPolicyMapper);
        if (this.properties.isCache()) {
            policyExecutor = new PolicyCachingExecutor((PolicyExecutor)policyExecutor);
        }
        return policyExecutor;
    }

    @Bean
    @ConditionalOnBean(value={PolicyQueryService.class})
    public List<PolicyFilterHandler> policyFilterHandlers(PolicyQueryService policyQueryService) {
        ArrayList<PolicyFilterHandler> policyHandlers = new ArrayList<PolicyFilterHandler>();
        policyHandlers.add((PolicyFilterHandler)new AllowListPolicyFilterHandler(policyQueryService));
        policyHandlers.add((PolicyFilterHandler)new BlockListPolicyFilterHandler());
        policyHandlers.add((PolicyFilterHandler)new BasePolicyFilterHandler(policyQueryService));
        policyHandlers.add((PolicyFilterHandler)new NonePolicyFilterHandler(policyQueryService));
        AnnotationAwareOrderComparator.sort(policyHandlers);
        return policyHandlers;
    }

    @Bean
    @ConditionalOnBean(value={PolicyQueryService.class})
    public List<PolicyInterceptorHandler> policyInterceptorHandlers(PolicyQueryService policyQueryService) {
        ArrayList<PolicyInterceptorHandler> handlers = new ArrayList<PolicyInterceptorHandler>();
        Set<PolicyType> policies = this.properties.getPolicy();
        if (policies.contains(PolicyType.Function)) {
            handlers.add((PolicyInterceptorHandler)new FunctionPolicyInterceptorHandler(policyQueryService));
        }
        if (policies.contains(PolicyType.Obsolete)) {
            handlers.add((PolicyInterceptorHandler)new ObsoletePolicyInterceptorHandler(policyQueryService));
        }
        AnnotationAwareOrderComparator.sort(handlers);
        return handlers;
    }

    @Bean
    @ConditionalOnBean(value={PolicyQueryService.class})
    @ConditionalOnMissingBean(name={"ramFilter"})
    public FilterRegistrationBean<Filter> ramFilter(PolicyQueryService policyQueryService) {
        FilterRegistrationBean registrationBean = new FilterRegistrationBean();
        registrationBean.setFilter((Filter)new ResourceAccessManagementFilter(this.policyFilterHandlers(policyQueryService)));
        registrationBean.setOrder(-99);
        registrationBean.addUrlPatterns(Constant.DEFAULT_URL_MAPPINGS);
        registrationBean.setAsyncSupported(true);
        return registrationBean;
    }

    @Bean
    @ConditionalOnBean(value={PolicyQueryService.class})
    @ConditionalOnMissingBean(name={"ramInterceptor"})
    public MappedInterceptor ramInterceptor(PolicyQueryService policyQueryService) {
        ResourceAccessManagementInterceptor interceptor = new ResourceAccessManagementInterceptor(this.policyInterceptorHandlers(policyQueryService));
        return new MappedInterceptor(Constant.DEFAULT_PATH_MAPPINGS, (HandlerInterceptor)interceptor);
    }
}

