/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middle.autoconfigure.config;

import com.digiwin.dap.middle.autoconfigure.properties.RamProperties;
import com.digiwin.dap.middle.ram.constant.Constant;
import com.digiwin.dap.middle.ram.filter.AfterAuthenticationFilter;
import com.digiwin.dap.middle.ram.filter.AppAuthCheckFilter;
import com.digiwin.dap.middle.ram.filter.BeforeAuthenticationFilter;
import com.digiwin.dap.middle.ram.interceptor.PreHandleInterceptor;
import com.digiwin.dap.middle.ram.mapper.RamPolicyMapper;
import com.digiwin.dap.middle.ram.service.AppAuthCheckService;
import com.digiwin.dap.middle.ram.service.PolicyQueryService;
import com.digiwin.dap.middle.ram.service.executor.GrantCachingExecutor;
import com.digiwin.dap.middle.ram.service.executor.GrantExecutor;
import com.digiwin.dap.middle.ram.service.executor.GrantSimpleExecutor;
import com.digiwin.dap.middle.ram.service.executor.PolicyCachingExecutor;
import com.digiwin.dap.middle.ram.service.executor.PolicyExecutor;
import com.digiwin.dap.middle.ram.service.executor.PolicySimpleExecutor;
import com.digiwin.dap.middle.ram.service.policy.filiter.AllowListPolicyFilterHandler;
import com.digiwin.dap.middle.ram.service.policy.filiter.BasePolicyFilterHandler;
import com.digiwin.dap.middle.ram.service.policy.filiter.BlockListPolicyFilterHandler;
import com.digiwin.dap.middle.ram.service.policy.filiter.NonePolicyFilterHandler;
import com.digiwin.dap.middle.ram.service.policy.filiter.ObsoletePolicyFilterHandler;
import com.digiwin.dap.middle.ram.service.policy.interceptor.FunctionPolicyInterceptorHandler;
import com.digiwin.dap.middle.ram.service.policy.interceptor.MergePolicyInterceptorHandler;
import java.util.ArrayList;
import javax.servlet.Filter;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.handler.MappedInterceptor;

@Configuration
@ComponentScan(basePackages={"com.digiwin.dap.middle.ram"})
@MapperScan(value={"com.digiwin.dap.middle.ram.mapper"})
@EnableConfigurationProperties(value={RamProperties.class})
public class RamScanConfiguration {
    private final RamProperties properties;

    public RamScanConfiguration(RamProperties properties) {
        this.properties = properties;
    }

    @Bean
    public GrantExecutor grantExecutor(RamPolicyMapper ramPolicyMapper) {
        GrantSimpleExecutor grantExecutor = new GrantSimpleExecutor(ramPolicyMapper);
        if (this.properties.isCache()) {
            grantExecutor = new GrantCachingExecutor((GrantExecutor)grantExecutor);
        }
        return grantExecutor;
    }

    @Bean
    public PolicyExecutor policyExecutor(RamPolicyMapper ramPolicyMapper) {
        PolicySimpleExecutor policyExecutor = new PolicySimpleExecutor(ramPolicyMapper);
        if (this.properties.isCache()) {
            policyExecutor = new PolicyCachingExecutor((PolicyExecutor)policyExecutor);
        }
        return policyExecutor;
    }

    @Bean
    @ConditionalOnBean(value={PolicyQueryService.class})
    @ConditionalOnMissingBean(name={"beforeAuthenticationFilter"})
    public FilterRegistrationBean<Filter> beforeAuthenticationFilter(PolicyQueryService policyQueryService) {
        ArrayList<Object> policyHandlers = new ArrayList<Object>();
        policyHandlers.add(new NonePolicyFilterHandler(policyQueryService));
        if (this.properties.isObsolete()) {
            policyHandlers.add(new ObsoletePolicyFilterHandler(policyQueryService));
        }
        AnnotationAwareOrderComparator.sort(policyHandlers);
        FilterRegistrationBean registrationBean = new FilterRegistrationBean();
        BeforeAuthenticationFilter beforeAuthenticationFilter = new BeforeAuthenticationFilter(policyHandlers, this.properties.isObsolete());
        registrationBean.setFilter((Filter)beforeAuthenticationFilter);
        registrationBean.setOrder(beforeAuthenticationFilter.getOrder());
        registrationBean.addUrlPatterns(Constant.DEFAULT_URL_MAPPINGS);
        registrationBean.setAsyncSupported(true);
        return registrationBean;
    }

    @Bean
    @ConditionalOnBean(value={PolicyQueryService.class})
    @ConditionalOnMissingBean(name={"afterAuthenticationFilter"})
    public FilterRegistrationBean<Filter> afterAuthenticationFilter(PolicyQueryService policyQueryService) {
        ArrayList<Object> policyHandlers = new ArrayList<Object>();
        policyHandlers.add(new AllowListPolicyFilterHandler(policyQueryService));
        policyHandlers.add(new BlockListPolicyFilterHandler());
        policyHandlers.add(new BasePolicyFilterHandler(policyQueryService));
        AnnotationAwareOrderComparator.sort(policyHandlers);
        FilterRegistrationBean registrationBean = new FilterRegistrationBean();
        AfterAuthenticationFilter afterAuthenticationFilter = new AfterAuthenticationFilter(policyHandlers);
        registrationBean.setFilter((Filter)afterAuthenticationFilter);
        registrationBean.setOrder(afterAuthenticationFilter.getOrder());
        registrationBean.addUrlPatterns(Constant.DEFAULT_URL_MAPPINGS);
        registrationBean.setAsyncSupported(true);
        return registrationBean;
    }

    @Bean
    @ConditionalOnBean(value={AppAuthCheckService.class, PolicyQueryService.class})
    @ConditionalOnMissingBean(name={"appAuthCheckFilter"})
    public FilterRegistrationBean<Filter> appAuthCheckFilter(AppAuthCheckService appAuthCheckService, PolicyQueryService policyQueryService) {
        FilterRegistrationBean registrationBean = new FilterRegistrationBean();
        AppAuthCheckFilter appAuthCheckFilter = new AppAuthCheckFilter(this.properties.isAppCheck(), appAuthCheckService, policyQueryService);
        registrationBean.setFilter((Filter)appAuthCheckFilter);
        registrationBean.setOrder(appAuthCheckFilter.getOrder());
        registrationBean.addUrlPatterns(Constant.DEFAULT_URL_MAPPINGS);
        registrationBean.setAsyncSupported(true);
        return registrationBean;
    }

    @Bean
    @ConditionalOnBean(value={PolicyQueryService.class})
    @ConditionalOnMissingBean(name={"preHandleInterceptor"})
    public MappedInterceptor preHandleInterceptor(PolicyQueryService policyQueryService) {
        ArrayList<Object> policyHandlers = new ArrayList<Object>();
        if (this.properties.isFunction()) {
            policyHandlers.add(new FunctionPolicyInterceptorHandler(policyQueryService));
        }
        policyHandlers.add(new MergePolicyInterceptorHandler());
        AnnotationAwareOrderComparator.sort(policyHandlers);
        PreHandleInterceptor interceptor = new PreHandleInterceptor(policyHandlers);
        return new MappedInterceptor(Constant.DEFAULT_PATH_MAPPINGS, (HandlerInterceptor)interceptor);
    }
}

