package com.digiwin.dap.middle.autoconfigure.config;

import com.digiwin.dap.middle.autoconfigure.properties.RamProperties;
import com.digiwin.dap.middle.ram.mapper.RamExecutorMapper;
import com.digiwin.dap.middle.ram.service.executor.GrantExecutor;
import com.digiwin.dap.middle.ram.service.executor.PolicyExecutor;
import com.digiwin.dap.middle.ram.service.executor.RouteExecutor;
import com.digiwin.dap.middle.ram.service.executor.cache.GrantCachingExecutor;
import com.digiwin.dap.middle.ram.service.executor.cache.PolicyCachingExecutor;
import com.digiwin.dap.middle.ram.service.executor.cache.RouteCachingExecutor;
import com.digiwin.dap.middle.ram.service.executor.simple.GrantSimpleExecutor;
import com.digiwin.dap.middle.ram.service.executor.simple.PolicySimpleExecutor;
import com.digiwin.dap.middle.ram.service.executor.simple.RouteSimpleExecutor;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;

/**
 * 基础服务
 *
 * @author fobgochod
 * @date 2021/8/20 11:45
 */
@Configuration
@ComponentScan(basePackages = "com.digiwin.dap.middle.ram")
@MapperScan("com.digiwin.dap.middle.ram.mapper")
@EnableConfigurationProperties(RamProperties.class)
public class RamScanConfiguration {

    private final RamProperties properties;

    public RamScanConfiguration(RamProperties properties) {
        this.properties = properties;
    }

    @Bean
    public GrantExecutor grantExecutor(RamExecutorMapper ramExecutorMapper) {
        GrantExecutor executor = new GrantSimpleExecutor(ramExecutorMapper);
        if (properties.isCache()) {
            executor = new GrantCachingExecutor(executor);
        }
        return executor;
    }

    @Bean
    public PolicyExecutor policyExecutor(RamExecutorMapper ramExecutorMapper) {
        PolicyExecutor executor = new PolicySimpleExecutor(ramExecutorMapper);
        if (properties.isCache()) {
            executor = new PolicyCachingExecutor(executor);
        }
        return executor;
    }

    @Bean
    public RouteExecutor routeExecutor(RamExecutorMapper ramExecutorMapper) {
        RouteExecutor executor = new RouteSimpleExecutor(ramExecutorMapper);
        if (properties.isCache()) {
            executor = new RouteCachingExecutor(executor);
        }
        return executor;
    }
}
