/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middle.autoconfigure;

import com.digiwin.dap.middle.autoconfigure.config.RamCoreConfiguration;
import com.digiwin.dap.middle.autoconfigure.config.RamScanConfiguration;
import com.digiwin.dap.middle.autoconfigure.properties.RamType;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import org.springframework.util.Assert;

final class RamConfigurations {
    private static final Map<RamType, Class<?>> MAPPINGS;

    private RamConfigurations() {
    }

    public static String getConfigurationClass(RamType ramType) {
        Class<?> configurationClass = MAPPINGS.get((Object)ramType);
        Assert.state((configurationClass != null ? 1 : 0) != 0, () -> "Unknown ram type " + (Object)((Object)ramType));
        return configurationClass.getName();
    }

    public static RamType getType(String configurationClassName) {
        for (Map.Entry<RamType, Class<?>> entry : MAPPINGS.entrySet()) {
            if (!entry.getValue().getName().equals(configurationClassName)) continue;
            return entry.getKey();
        }
        throw new IllegalStateException("Unknown configuration class " + configurationClassName);
    }

    static {
        EnumMap<RamType, Class> mappings = new EnumMap<RamType, Class>(RamType.class);
        mappings.put(RamType.SCAN, RamScanConfiguration.class);
        mappings.put(RamType.CORE, RamCoreConfiguration.class);
        MAPPINGS = Collections.unmodifiableMap(mappings);
    }
}

