/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middle.autoconfigure.config;

import com.digiwin.dap.middle.autoconfigure.condition.IamV1Condition;
import com.digiwin.dap.middle.autoconfigure.properties.RamProperties;
import com.digiwin.dap.middle.ram.constant.RamConstant;
import com.digiwin.dap.middle.ram.domain.request.AccessUser;
import com.digiwin.dap.middle.ram.filter.RamV1AccessCheckFilter;
import com.digiwin.dap.middle.ram.service.core.RamCoreService;
import com.digiwin.dap.middle.ram.support.DefaultRamHandlerSupport;
import com.digiwin.dap.middle.ram.support.RamHandlerSupport;
import com.digiwin.dap.middle.ram.support.security.auth.AuthPolicyHandler;
import com.digiwin.dap.middle.ram.support.security.auth.AuthPolicyHandlerComposite;
import com.digiwin.dap.middle.ram.support.security.path.PathPolicyHandler;
import com.digiwin.dap.middle.ram.support.security.path.PathPolicyHandlerComposite;
import javax.servlet.Filter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.SearchStrategy;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={RamProperties.class})
public class RamCoreConfiguration {
    private final RamProperties properties;

    public RamCoreConfiguration(RamProperties properties) {
        this.properties = properties;
    }

    @Bean
    @ConditionalOnMissingBean(value={RamHandlerSupport.class}, search=SearchStrategy.CURRENT)
    public RamHandlerSupport ramHandlerSupport() {
        return new DefaultRamHandlerSupport();
    }

    @Bean
    @ConditionalOnBean(value={RamCoreService.class, RamHandlerSupport.class})
    public PathPolicyHandlerComposite pathPolicyHandler(RamCoreService ramCoreService, RamHandlerSupport ramHandlerSupport) {
        return new PathPolicyHandlerComposite(ramCoreService, ramHandlerSupport, this.properties.isFunction());
    }

    @Bean
    @ConditionalOnBean(value={RamCoreService.class, RamHandlerSupport.class})
    public AuthPolicyHandlerComposite authPolicyHandler(RamCoreService ramCoreService, RamHandlerSupport ramHandlerSupport) {
        return new AuthPolicyHandlerComposite(ramCoreService, ramHandlerSupport);
    }

    @Bean
    @ConditionalOnBean(value={PathPolicyHandler.class, AuthPolicyHandler.class})
    @Conditional(value={IamV1Condition.class})
    public FilterRegistrationBean<Filter> ramAccessCheckRegistration(PathPolicyHandler<AccessUser> pathPolicyHandler, AuthPolicyHandler authPolicyHandler) {
        FilterRegistrationBean registrationBean = new FilterRegistrationBean();
        RamV1AccessCheckFilter filter = new RamV1AccessCheckFilter(pathPolicyHandler, authPolicyHandler);
        registrationBean.setFilter((Filter)filter);
        registrationBean.setOrder(filter.getOrder());
        registrationBean.addUrlPatterns(RamConstant.DEFAULT_URL_MAPPINGS);
        registrationBean.setAsyncSupported(true);
        return registrationBean;
    }
}

