package com.digiwin.dap.middle.autoconfigure;

import com.digiwin.dap.middle.autoconfigure.condition.RamOrIamV1Condition;
import com.digiwin.dap.middle.autoconfigure.properties.RamType;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.ImportSelector;
import org.springframework.core.type.AnnotationMetadata;

/**
 * {@link EnableAutoConfiguration Auto-Configuration} for DAP RAM.
 *
 * @author fobgochod
 */
@AutoConfiguration
@ConditionalOnWebApplication
@Conditional(RamOrIamV1Condition.class)
@Import(RamAutoConfiguration.RamConfigurationImportSelector.class)
public class RamAutoConfiguration {

    static class RamConfigurationImportSelector implements ImportSelector {
        @Override
        public String[] selectImports(AnnotationMetadata importingClassMetadata) {
            RamType[] types = RamType.values();
            String[] imports = new String[types.length];
            for (int i = 0; i < types.length; i++) {
                imports[i] = RamConfigurations.getConfigurationClass(types[i]);
            }
            return imports;
        }
    }
}
