/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middle.autoconfigure.config;

import com.digiwin.dap.middle.autoconfigure.properties.RamProperties;
import com.digiwin.dap.middle.ram.mapper.RamExecutorMapper;
import com.digiwin.dap.middle.ram.service.executor.RamGrantExecutor;
import com.digiwin.dap.middle.ram.service.executor.RamPolicyExecutor;
import com.digiwin.dap.middle.ram.service.executor.RamRouteExecutor;
import com.digiwin.dap.middle.ram.service.executor.local.RamGrantLocalCacheExecutor;
import com.digiwin.dap.middle.ram.service.executor.local.RamPolicyLocalCacheExecutor;
import com.digiwin.dap.middle.ram.service.executor.local.RamRouteLocalCacheExecutor;
import com.digiwin.dap.middle.ram.service.executor.redis.RamGrantRedisCacheExecutor;
import com.digiwin.dap.middle.ram.service.executor.redis.RamPolicyRedisCacheExecutor;
import com.digiwin.dap.middle.ram.service.executor.redis.RamRouteRedisCacheExecutor;
import com.digiwin.dap.middle.ram.service.executor.simple.RamGrantSimpleExecutor;
import com.digiwin.dap.middle.ram.service.executor.simple.RamPolicySimpleExecutor;
import com.digiwin.dap.middle.ram.service.executor.simple.RamRouteSimpleExecutor;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;

@Configuration
@ComponentScan(basePackages={"com.digiwin.dap.middle.ram"})
@MapperScan(value={"com.digiwin.dap.middle.ram.mapper"})
@EnableConfigurationProperties(value={RamProperties.class})
public class RamScanConfiguration {
    private final RamProperties properties;
    @Value(value="${spring.application.name:dap}")
    private String appName;

    public RamScanConfiguration(RamProperties properties) {
        this.properties = properties;
    }

    @Bean
    public RamGrantExecutor ramGrantExecutor(RamExecutorMapper mapper) {
        RamGrantSimpleExecutor simpleExecutor = new RamGrantSimpleExecutor(mapper);
        RamGrantRedisCacheExecutor redisExecutor = new RamGrantRedisCacheExecutor((RamGrantExecutor)simpleExecutor);
        if (this.properties.isCache()) {
            return new RamGrantLocalCacheExecutor(this.appName, (RamGrantExecutor)redisExecutor);
        }
        return redisExecutor;
    }

    @Bean
    public RamPolicyExecutor ramPolicyExecutor(RamExecutorMapper mapper) {
        RamPolicySimpleExecutor simpleExecutor = new RamPolicySimpleExecutor(mapper);
        RamPolicyRedisCacheExecutor redisExecutor = new RamPolicyRedisCacheExecutor((RamPolicyExecutor)simpleExecutor);
        if (this.properties.isCache()) {
            return new RamPolicyLocalCacheExecutor(this.appName, (RamPolicyExecutor)redisExecutor);
        }
        return redisExecutor;
    }

    @Bean
    public RamRouteExecutor ramRouteExecutor(RamExecutorMapper mapper) {
        RamRouteSimpleExecutor simpleExecutor = new RamRouteSimpleExecutor(mapper);
        RamRouteRedisCacheExecutor redisExecutor = new RamRouteRedisCacheExecutor((RamRouteExecutor)simpleExecutor);
        if (this.properties.isCache()) {
            return new RamRouteLocalCacheExecutor(this.appName, (RamRouteExecutor)redisExecutor);
        }
        return redisExecutor;
    }
}

