package com.digiwin.dap.middle.autoconfigure.config;

import com.digiwin.dap.middle.autoconfigure.properties.RamProperties;
import com.digiwin.dap.middle.ram.mapper.RamExecutorMapper;
import com.digiwin.dap.middle.ram.service.executor.*;
import com.digiwin.dap.middle.ram.service.executor.local.RamGrantLocalCacheExecutor;
import com.digiwin.dap.middle.ram.service.executor.local.RamPolicyLocalCacheExecutor;
import com.digiwin.dap.middle.ram.service.executor.local.RamRouteLocalCacheExecutor;
import com.digiwin.dap.middle.ram.service.executor.redis.*;
import com.digiwin.dap.middle.ram.service.executor.simple.*;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;

/**
 * 基础服务
 *
 * @author fobgochod
 */
@Configuration
@ComponentScan(basePackages = "com.digiwin.dap.middle.ram")
@MapperScan("com.digiwin.dap.middle.ram.mapper")
@EnableConfigurationProperties(RamProperties.class)
public class RamScanConfiguration {

    private final RamProperties properties;

    @Value("${spring.application.name:dap}")
    private String appName;

    public RamScanConfiguration(RamProperties properties) {
        this.properties = properties;
    }

    @Bean
    public RamGrantExecutor ramGrantExecutor(RamExecutorMapper mapper) {
        RamGrantExecutor simpleExecutor = new RamGrantSimpleExecutor(mapper);
        RamGrantExecutor redisExecutor = new RamGrantRedisCacheExecutor(simpleExecutor);
        if (properties.isCache()) {
            return new RamGrantLocalCacheExecutor(appName, redisExecutor);
        }
        return redisExecutor;
    }

    @Bean
    public RamPolicyExecutor ramPolicyExecutor(RamExecutorMapper mapper) {
        RamPolicyExecutor simpleExecutor = new RamPolicySimpleExecutor(mapper);
        RamPolicyExecutor redisExecutor = new RamPolicyRedisCacheExecutor(simpleExecutor);
        if (properties.isCache()) {
            return new RamPolicyLocalCacheExecutor(appName, redisExecutor);
        }
        return redisExecutor;
    }

    @Bean
    public RamRouteExecutor ramRouteExecutor(RamExecutorMapper mapper) {
        RamRouteExecutor simpleExecutor = new RamRouteSimpleExecutor(mapper);
        RamRouteExecutor redisExecutor = new RamRouteRedisCacheExecutor(simpleExecutor);
        if (properties.isCache()) {
            return new RamRouteLocalCacheExecutor(appName, redisExecutor);
        }
        return redisExecutor;
    }

    @Bean
    public RamGroupGrantExecutor ramGroupGrantExecutor(RamExecutorMapper mapper) {
        RamGroupGrantExecutor executor = new RamGroupGrantSimpleExecutor(mapper);
        return new RamGroupGrantCachingExecutor(executor);
    }

    @Bean
    public RamGroupPolicyExecutor ramGroupPolicyExecutor(RamExecutorMapper mapper) {
        RamGroupPolicyExecutor executor = new RamGroupPolicySimpleExecutor(mapper);
        return new RamGroupPolicyCachingExecutor(executor);
    }
}
