package com.digiwin.dap.middle.autoconfigure.properties;

import com.digiwin.dap.middleware.auth.domain.RamVersion;
import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * Configuration properties for DAP RAM.
 *
 * @author fobgochod
 */
@ConfigurationProperties(prefix = RamProperties.DAP_RAM_PREFIX)
public class RamProperties {

    public static final String DAP_RAM_PREFIX = "dap.middleware.ram";

    /**
     * 启用RAM鉴权的方式 {@link RamVersion}
     */
    private String version = RamVersion.v1.name();

    /**
     * Whether to enable local cache.
     */
    private boolean cache;

    /**
     * 是否启用功能权限策略
     */
    private boolean function;

    public String getVersion() {
        return version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public boolean isCache() {
        return cache;
    }

    public void setCache(boolean cache) {
        this.cache = cache;
    }

    public boolean isFunction() {
        return function;
    }

    public void setFunction(boolean function) {
        this.function = function;
    }
}
