package com.digiwin.dap.middle.ram.api;

import com.digiwin.dap.middle.ram.entity.GrantPolicy;
import com.digiwin.dap.middle.ram.mapper.RamGrantPolicyCrudMapper;
import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.util.JdbcUtils;
import com.digiwin.dap.middleware.util.SnowFlake;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * GrantController.java
 *
 * @author Xiao
 * @date 2021/8/19 9:31
 */
@RequestMapping("/api/ram/v2/data")
@RestController
public class DataApi {

    @Autowired
    private RamGrantPolicyCrudMapper grantPolicyCrudMapper;

    @GetMapping
    public StdData<?> data() {
        List<GrantPolicy> grantPolicies = grantPolicyCrudMapper.getByPolicySid(11);
        for (GrantPolicy grantPolicy : grantPolicies) {
            boolean exists = grantPolicyCrudMapper.exists(grantPolicy.getGrantSid(), 200);
            if (!exists) {
                grantPolicy.setSid(SnowFlake.getInstance().newId());
                grantPolicy.setPolicySid(200);
                grantPolicyCrudMapper.insert(grantPolicy);
            }
        }
        return StdData.ok();
    }
}
