package com.digiwin.dap.middle.ram.api;

import com.digiwin.dap.middle.ram.domain.GrantVO;
import com.digiwin.dap.middle.ram.entity.BaseSid;
import com.digiwin.dap.middle.ram.entity.Grant;
import com.digiwin.dap.middle.ram.service.CacheHandlerService;
import com.digiwin.dap.middle.ram.service.base.RamGrantCrudService;
import com.digiwin.dap.middle.ram.service.base.RamGrantPolicyCrudService;
import com.digiwin.dap.middleware.domain.StdData;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * GrantController.java
 *
 * @author Xiao
 * @date 2021/8/19 9:31
 */
@RequestMapping("/api/ram/v2/grant")
@RestController
public class GrantApi {

    @Autowired
    private RamGrantCrudService ramGrantCrudService;
    @Autowired
    private CacheHandlerService cacheHandlerService;
    @Autowired
    private RamGrantPolicyCrudService ramGrantPolicyCrudService;

    @PostMapping("/add")
    public StdData<?> add(@RequestBody Grant body) {
        long sid = ramGrantCrudService.insert(body);
        return StdData.ofSuccess(BaseSid.ok(sid));
    }

    @Transactional
    @PostMapping("/del")
    public StdData<?> del(@RequestBody BaseSid body) {
        Grant grant = ramGrantCrudService.findBySid(body.getSid());
        if (grant != null) {
            cacheHandlerService.grantChanged(grant.getType(), grant.getTargetId());
            int count = ramGrantCrudService.deleteBySid(body.getSid());
            ramGrantPolicyCrudService.deleteByGrantSid(body.getSid());
            return StdData.ofSuccess(BaseSid.ok(count));
        }
        return StdData.ofSuccess(BaseSid.ok(0));
    }

    @PostMapping("/get")
    public StdData<?> get(@RequestBody BaseSid body) {
        Grant grant = ramGrantCrudService.findBySid(body.getSid());
        if (grant != null) {
            return StdData.ofSuccess(grant);
        }
        return StdData.ofSuccess(BaseSid.ok(0));
    }

    @PostMapping("/find")
    public StdData<?> find(@RequestBody GrantVO body) {
        body.setOrderBy("g.create_date desc");
        return StdData.ofSuccess(ramGrantCrudService.findByPage(body));
    }

    @PostMapping("/query")
    public StdData<?> query(@RequestBody GrantVO body) {
        body.setOrderBy("g.create_date desc");
        return StdData.ofSuccess(ramGrantCrudService.findByPage0(body));
    }
}
