package com.digiwin.dap.middle.ram.api;

import com.digiwin.dap.middle.ram.domain.GrantVO;
import com.digiwin.dap.middle.ram.domain.PolicyVO;
import com.digiwin.dap.middle.ram.entity.BaseSid;
import com.digiwin.dap.middle.ram.entity.GrantPolicy;
import com.digiwin.dap.middle.ram.service.CacheHandlerService;
import com.digiwin.dap.middle.ram.service.base.RamGrantPolicyCrudService;
import com.digiwin.dap.middleware.domain.StdData;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 目标策略
 *
 * @author Xiao
 * @date 2021/8/19 9:31
 */
@RequestMapping("/api/ram/v2/gp")
@RestController
public class GrantPolicyApi {

    @Autowired
    private CacheHandlerService cacheHandlerService;
    @Autowired
    private RamGrantPolicyCrudService ramGrantPolicyCrudService;

    @PostMapping("/add")
    public StdData<?> add(@RequestBody GrantPolicy body) {
        long sid = ramGrantPolicyCrudService.insert(body);
        cacheHandlerService.grantPolicyChanged(sid);
        return StdData.ofSuccess(BaseSid.ok(sid));
    }

    @PostMapping("/del")
    public StdData<?> del(@RequestBody BaseSid body) {
        cacheHandlerService.grantPolicyChanged(body.getSid());
        int count = ramGrantPolicyCrudService.deleteBySid(body.getSid());
        return StdData.ofSuccess(BaseSid.ok(count));
    }

    @PostMapping("/find")
    public StdData<?> find(@RequestBody GrantVO body) {
        body.setOrderBy("gp.create_date desc");
        return StdData.ofSuccess(ramGrantPolicyCrudService.findByPage0(body));
    }

    @PostMapping("/find/grant")
    public StdData<?> getGrant(@RequestBody GrantPolicy body) {
        List<GrantVO> grants = ramGrantPolicyCrudService.findByPolicySid(body.getPolicySid());
        return StdData.ofSuccess(grants);
    }

    @PostMapping("/find/policy")
    public StdData<?> getPolicy(@RequestBody GrantPolicy body) {
        List<PolicyVO> policies = ramGrantPolicyCrudService.findByGrantSid(body.getGrantSid());
        return StdData.ofSuccess(policies);
    }
}
