package com.digiwin.dap.middle.ram.api;

import com.digiwin.dap.middle.ram.domain.PolicyVO;
import com.digiwin.dap.middle.ram.entity.BaseSid;
import com.digiwin.dap.middle.ram.entity.Policy;
import com.digiwin.dap.middle.ram.service.CacheHandlerService;
import com.digiwin.dap.middle.ram.service.base.RamPolicyCrudService;
import com.digiwin.dap.middle.ram.service.base.RamPolicyRouteCrudService;
import com.digiwin.dap.middleware.domain.StdData;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * PolicyController.java
 *
 * @author Xiao
 * @date 2021/8/19 9:31
 */
@RequestMapping("/api/ram/v2/policy")
@RestController
public class PolicyApi {

    @Autowired
    private CacheHandlerService cacheHandlerService;
    @Autowired
    private RamPolicyCrudService ramPolicyCrudService;
    @Autowired
    private RamPolicyRouteCrudService ramPolicyRouteCrudService;

    @PostMapping("/add")
    public StdData<?> add(@RequestBody Policy body) {
        long sid = ramPolicyCrudService.insert(body);
        return StdData.ofSuccess(BaseSid.ok(sid));
    }

    @Transactional
    @PostMapping("/del")
    public StdData<?> del(@RequestBody BaseSid body) {
        Policy policy = ramPolicyCrudService.findBySid(body.getSid());
        if (policy != null) {
            cacheHandlerService.policyChanged(policy.getType(), policy.getId());
            int count = ramPolicyCrudService.deleteBySid(body.getSid());
            ramPolicyRouteCrudService.deleteByPolicySid(body.getSid());
            return StdData.ofSuccess(BaseSid.ok(count));
        }
        return StdData.ofSuccess(BaseSid.ok(0));
    }

    @PostMapping("/mod")
    public StdData<?> mod(@RequestBody Policy body) {
        Policy policy = ramPolicyCrudService.findBySid(body.getSid());
        if (policy != null) {
            policy.setName(body.getName());
            ramPolicyCrudService.update(policy);
            return StdData.ofSuccess(BaseSid.ok(policy.getSid()));
        }
        return StdData.ofSuccess(BaseSid.ok(0));
    }

    @PostMapping("/get")
    public StdData<?> get(@RequestBody BaseSid body) {
        Policy path = ramPolicyCrudService.findBySid(body.getSid());
        if (path != null) {
            return StdData.ofSuccess(path);
        }
        return StdData.ofSuccess(BaseSid.ok(0));
    }

    @PostMapping("/find")
    public StdData<?> find(@RequestBody PolicyVO body) {
        return StdData.ofSuccess(ramPolicyCrudService.findByPage(body));
    }

    @PostMapping("/query")
    public StdData<?> query(@RequestBody PolicyVO body) {
        body.setOrderBy("p.create_date desc");
        return StdData.ofSuccess(ramPolicyCrudService.findByPage0(body));
    }
}
