package com.digiwin.dap.middle.ram.api;

import com.digiwin.dap.middle.ram.domain.PolicyVO;
import com.digiwin.dap.middle.ram.domain.RouteVO;
import com.digiwin.dap.middle.ram.entity.BaseSid;
import com.digiwin.dap.middle.ram.entity.PolicyRoute;
import com.digiwin.dap.middle.ram.service.CacheHandlerService;
import com.digiwin.dap.middle.ram.service.base.RamPolicyRouteCrudService;
import com.digiwin.dap.middleware.domain.StdData;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 策略路由
 *
 * @author Xiao
 * @date 2021/8/19 9:31
 */
@RequestMapping("/api/ram/v2/pr")
@RestController
public class PolicyRouteApi {

    @Autowired
    private CacheHandlerService cacheHandlerService;
    @Autowired
    private RamPolicyRouteCrudService ramPolicyRouteCrudService;

    @PostMapping("/add")
    public StdData<?> add(@RequestBody PolicyRoute body) {
        long sid = ramPolicyRouteCrudService.insert(body);
        cacheHandlerService.policyRouteChanged(sid);
        return StdData.ofSuccess(BaseSid.ok(sid));
    }

    @PostMapping("/del")
    public StdData<?> del(@RequestBody BaseSid body) {
        cacheHandlerService.policyRouteChanged(body.getSid());
        int count = ramPolicyRouteCrudService.deleteBySid(body.getSid());
        return StdData.ofSuccess(BaseSid.ok(count));
    }

    @PostMapping("/find/policy")
    public StdData<?> getPolicy(@RequestBody PolicyRoute body) {
        List<PolicyVO> policies = ramPolicyRouteCrudService.findByRouteSid(body.getRouteSid());
        return StdData.ofSuccess(policies);
    }

    @PostMapping("/find/route")
    public StdData<?> getRoute(@RequestBody PolicyRoute body) {
        List<RouteVO> routes = ramPolicyRouteCrudService.findByPolicySid(body.getPolicySid());
        return StdData.ofSuccess(routes);
    }
}
