package com.digiwin.dap.middle.ram.api;

import com.digiwin.dap.middle.ram.domain.RouteVO;
import com.digiwin.dap.middle.ram.entity.BaseSid;
import com.digiwin.dap.middle.ram.entity.Route;
import com.digiwin.dap.middle.ram.service.CacheHandlerService;
import com.digiwin.dap.middle.ram.service.base.RamRouteCrudService;
import com.digiwin.dap.middleware.domain.StdData;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * RouteController.java
 *
 * @author Xiao
 * @date 2021/8/16 20:02
 */
@RequestMapping("/api/ram/v2/route")
@RestController
public class RouteApi {

    @Autowired
    private CacheHandlerService cacheHandlerService;
    @Autowired
    private RamRouteCrudService ramRouteCrudService;

    @PostMapping("/add")
    public StdData<?> add(@RequestBody Route body) {
        long routeSid = ramRouteCrudService.insert(body);
        return StdData.ofSuccess(BaseSid.ok(routeSid));
    }

    @PostMapping("/del")
    public StdData<?> del(@RequestBody BaseSid body) {
        Route route = ramRouteCrudService.findBySid(body.getSid());
        if (route != null) {
            cacheHandlerService.routeChanged(route.getSid());
            int count = ramRouteCrudService.deleteBySid(body.getSid());
            return StdData.ofSuccess(BaseSid.ok(count));
        }
        return StdData.ofSuccess(BaseSid.ok(0));
    }

    @PostMapping("/get")
    public StdData<?> get(@RequestBody BaseSid body) {
        Route route = ramRouteCrudService.findBySid(body.getSid());
        if (route != null) {
            return StdData.ofSuccess(route);
        }
        return StdData.ofSuccess(BaseSid.ok(0));
    }

    @PostMapping("/find")
    public StdData<?> find(@RequestBody RouteVO body) {
        return StdData.ofSuccess(ramRouteCrudService.findByPage(body));
    }

    @PostMapping("/query")
    public StdData<?> query(@RequestBody RouteVO body) {
        body.setOrderBy("r.create_date desc");
        return StdData.ofSuccess(ramRouteCrudService.findByPage0(body));
    }
}
