package com.digiwin.dap.middle.ram.domain;

import com.digiwin.dap.middle.ram.domain.enums.AuthType;

import java.util.ArrayList;
import java.util.List;

/**
 * 授权结果
 *
 * @author fobgo
 * @date 2022/4/15 11:37
 */
public class AuthResult {
    /**
     * 给一个机会不去调用后续流程
     */
    private boolean disabled;
    /**
     * 需要检查授权的租户ID集合
     */
    private List<String> tenantIds;
    /**
     * 默认为null，当传递多个租户到cac检查授权时，返回任意有效租户
     */
    private String tenantId;
    /**
     * 授权结果
     */
    private AuthType authType;

    public AuthResult() {
        this.tenantIds = new ArrayList<>();
    }

    public static AuthResult of() {
        return new AuthResult();
    }

    public static AuthResult of(AuthType authType) {
        AuthResult result = AuthResult.of();
        result.setAuthType(authType);
        return result;
    }

    public boolean ok() {
        return this.authType == AuthType.AppOk;
    }

    public boolean isDisabled() {
        return disabled;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    public List<String> getTenantIds() {
        return tenantIds;
    }

    public void setTenantIds(List<String> tenantIds) {
        this.tenantIds = tenantIds;
    }

    public String getTenantId() {
        return tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public AuthType getAuthType() {
        return authType;
    }

    public void setAuthType(AuthType authType) {
        this.authType = authType;
    }
}
