package com.digiwin.dap.middle.ram.domain;

import com.digiwin.dap.middle.ram.domain.enums.AuthType;
import com.digiwin.dap.middle.ram.domain.enums.ResultType;
import com.digiwin.dap.middle.ram.domain.enums.TargetType;
import com.digiwin.dap.middle.ram.domain.function.Function;
import com.digiwin.dap.middleware.auth.AuthoredSys;
import com.digiwin.dap.middleware.auth.AuthoredUser;
import com.digiwin.dap.middleware.util.TokenUtils;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import static com.digiwin.dap.middle.ram.domain.enums.TargetType.*;

/**
 * 目标类型
 *
 * @author Xiao
 * @date 2021/8/16 15:53
 */
public class TargetInfo {

    private final Map<TargetType, String> targets = new LinkedHashMap<>(3);
    /**
     * 登录信息
     */
    private AuthoredUser user;
    private AuthoredSys sys;
    /**
     * 访问API信息
     */
    private PatternVO pattern;
    /**
     * 结果信息
     */
    private ResultType resultType = ResultType.IMPLICIT_DENY;
    private AuthResult authResult = new AuthResult();
    /**
     * 过时判断
     */
    private boolean obsolete;

    public void init() {
        if (targets.isEmpty()) {
            this.user = TokenUtils.getAuthoredUser();
            this.sys = TokenUtils.getAuthoredSys();

            if (this.user != null) {
                if (this.user.getTenantId() != null) {
                    this.targets.put(Tenant, this.user.getTenantId());
                }
                this.targets.put(User, this.user.getUserId());
            }
            if (this.sys != null) {
                this.targets.put(Sys, this.sys.getId());
            }
        }
    }

    public List<TargetType> targets() {
        return new ArrayList<>(targets.keySet());
    }

    public String obtain(TargetType targetType) {
        return targets.get(targetType);
    }

    public String functionKey() {
        return String.format(Function.REDIS_PERMISSION_KEY, targets.get(User), targets.get(Tenant), targets.get(Sys));
    }

    public AuthoredUser getUser() {
        return user;
    }

    public AuthoredSys getSys() {
        return sys;
    }

    public PatternVO getPattern() {
        return pattern;
    }

    public void setPattern(PatternVO pattern) {
        this.pattern = pattern;
    }

    public ResultType getResultType() {
        return resultType;
    }

    public void setResultType(ResultType resultType) {
        this.resultType = resultType;
    }

    public AuthResult getAuthResult() {
        return authResult;
    }

    public void setAuthResult(AuthResult authResult) {
        this.authResult = authResult;
    }

    public boolean isObsolete() {
        return obsolete;
    }

    public void setObsolete(boolean obsolete) {
        this.obsolete = obsolete;
    }
}
