package com.digiwin.dap.middle.ram.domain;

import org.springframework.core.NamedThreadLocal;
import org.springframework.lang.NonNull;

public final class TargetInfoContextHolder {

    private static final ThreadLocal<TargetInfo> context = new NamedThreadLocal<>("TargetInfoContext");

    private TargetInfoContextHolder() {
    }

    public static void clearContext() {
        context.remove();
    }

    public static void setContext(@NonNull TargetInfo targetInfo) {
        context.set(targetInfo);
    }

    public static TargetInfo getTargetInfo() {
        TargetInfo targetInfo = context.get();
        if (targetInfo == null) {
            targetInfo = new TargetInfo();
            context.set(targetInfo);
        }
        return targetInfo;
    }
}
