package com.digiwin.dap.middle.ram.domain.enums;

/**
 * 授权结果
 *
 * @author fobgo
 * @date 2022/4/11 17:00
 */
public enum AuthType {

    /**
     * 拥有授权，已经购买应用、未过期、用户加入授权
     */
    AppOk,
    /**
     * 没有购买应用
     */
    AppNone,
    /**
     * 已购买，但是应用过期
     */
    AppExpired,
    /**
     * 已购买、应用未过期、但是用户未加入
     */
    AppNoneUser;

    public static AuthType valueOf(int type) {
        for (AuthType authType : values()) {
            if (authType.ordinal() == type) {
                return authType;
            }
        }
        return null;
    }
}
