package com.digiwin.dap.middle.ram.domain.enums;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;

/**
 * 策略类型
 *
 * @author Xiao
 * @date 2021/8/16 15:37
 */
public enum PolicyType {

    /**
     * 不做权限管控，只有唯一一个策略
     */
    None,
    /**
     * 白名单
     */
    AllowList,
    /**
     * 黑名单（暂不处理）
     */
    BlockList,
    /**
     * 策略，系统策略(System)、自定义策略(Custom)
     */
    Base,
    /**
     * 功能权限策略
     */
    Function,
    /**
     * 废弃，只有唯一一个策略
     */
    Obsolete,

    /**
     * 啥也不需要
     * 不做授权检查
     */
    NoAuth,
    /**
     * 需要AppToken
     * <p>
     * 应用授权检查
     * 1、如果没有购买，直接放过
     * 2、购买了就检查过期时间
     */
    NoAuthApp,
    /**
     * 需要租户和AppToken
     * 用户授权检查
     * 1、租户需要购买应用
     * 2、不需要检查用户是否加入该应用
     */
    NoAuthUser;

    private static final Set<PolicyType> DEFAULT_POLICIES;

    static {
        Set<PolicyType> defaultIncludes = new LinkedHashSet<>();
        defaultIncludes.add(PolicyType.None);
        defaultIncludes.add(PolicyType.AllowList);
        defaultIncludes.add(PolicyType.BlockList);
        defaultIncludes.add(PolicyType.Base);
        DEFAULT_POLICIES = Collections.unmodifiableSet(defaultIncludes);
    }

    /**
     * Return the default {@link PolicyType}.
     *
     * @return the default include.
     */
    public static Set<PolicyType> defaultPolicies() {
        return DEFAULT_POLICIES;
    }
}
