package com.digiwin.dap.middle.ram.domain.function;

import com.digiwin.dap.middleware.cache.RedisUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class Function {

    /**
     * 依次为userId、tenantId、sysId
     * 用::分割，所以各id不能有2个以上::，不然模糊匹配可能出问题
     */
    public static final String REDIS_PERMISSION_KEY = "iam:permission:all:%s::%s::%s";

    private Result result;

    public Function() {
        this.result = new Result();
    }

    /**
     * 获取权限缓存，解析actionId和conditionId集合
     *
     * @param key 权限缓存的key
     */
    public static List<String> obtainPolicyIds(String key) {
        List<String> policyIds = new ArrayList<>();
        Function function = RedisUtils.get(key, Function.class);
        if (function == null || function.getResult() == null) {
            return policyIds;
        }
        List<String> actionIds = function.getResult().getPermissions().stream().map(Result.Permission::getId).collect(Collectors.toList());
        List<String> conditionIds = function.getResult().getPermissions().stream()
                .flatMap(action -> action.getConditions().entrySet().stream())
                .flatMap(condition -> condition.getValue().entrySet().stream())
                .map(Map.Entry::getKey).collect(Collectors.toList());

        policyIds.addAll(actionIds);
        policyIds.addAll(conditionIds);
        return policyIds;
    }

    public Result getResult() {
        return result;
    }

    public void setResult(Result result) {
        this.result = result;
    }

    public static class Result {

        private List<Permission> permissions;

        public List<Permission> getPermissions() {
            return permissions;
        }

        public void setPermissions(List<Permission> permissions) {
            this.permissions = permissions;
        }

        public static class Permission {
            private String id;
            private String target;
            private Map<String, Map<String, String>> conditions;

            public String getId() {
                return id;
            }

            public void setId(String id) {
                this.id = id;
            }

            public String getTarget() {
                return target;
            }

            public void setTarget(String target) {
                this.target = target;
            }

            public Map<String, Map<String, String>> getConditions() {
                return conditions;
            }

            public void setConditions(Map<String, Map<String, String>> conditions) {
                this.conditions = conditions;
            }
        }
    }
}
