package com.digiwin.dap.middle.ram.domain.page;

import java.util.Map;

public class Page extends PageInfo {

    /**
     * 查询条件
     */
    private Map<String, Object> filters;

    /**
     * 页码，从1开始
     */
    private Integer pageNum;
    /**
     * 页面大小
     */
    private Integer pageSize;
    /**
     * 排序
     */
    private String orderBy;
    /**
     * 总数
     */
    private Integer total;

    public Page() {
    }

    public Map<String, Object> getFilters() {
        return filters;
    }

    public void setFilters(Map<String, Object> filters) {
        this.filters = filters;
    }

    public Integer getPageNum() {
        return pageNum;
    }

    public void setPageNum(Integer pageNum) {
        this.pageNum = pageNum;
    }

    public Integer getPageSize() {
        return pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public String getOrderBy() {
        return orderBy;
    }

    public void setOrderBy(String orderBy) {
        this.orderBy = orderBy;
    }

    public Integer getTotal() {
        return total;
    }

    public void setTotal(Integer total) {
        this.total = total;
    }

    public PageInfo offsetPage() {
        this.pageNum = this.pageNum == null ? 0 : this.pageNum;
        this.pageSize = this.pageSize == null ? 10 : this.pageSize;

        this.setSkip((this.pageNum - 1) * this.pageSize);
        this.setLimit(this.pageSize);

        this.pageSize = null;
        this.pageNum = null;
        return this;
    }
}
