package com.digiwin.dap.middle.ram.filter;

import com.digiwin.dap.middle.ram.domain.PatternVO;
import com.digiwin.dap.middle.ram.entity.Route;
import com.digiwin.dap.middle.ram.mapper.RamRouteCrudMapper;
import com.digiwin.dap.middle.ram.util.MatcherUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;

@Component
public class PatternRegistry {

    private final Map<PatternVO, RequestMatcher> registry = new HashMap<>();
    private final ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();

    @Autowired
    private RamRouteCrudMapper ramRouteCrudMapper;

    public Map<PatternVO, RequestMatcher> getRegistry() {
        this.readWriteLock.readLock().lock();
        try {
            return registry;
        } finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    public void register(List<Route> routes) {
        this.readWriteLock.writeLock().lock();
        try {
            for (Route route : routes) {
                if (MappingRegistry.getPathMatcher().isPattern(route.getPath())) {
                    AntPathRequestMatcher matcher = new AntPathRequestMatcher(route.getPath(), route.getMethod());
                    registry.put(new PatternVO(route), matcher);
                }
            }
        } finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    public void register(PatternVO route, RequestMatcher matcher) {
        this.readWriteLock.writeLock().lock();
        try {
            registry.put(route, matcher);
        } finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    public void initData() {
        List<Route> routes = ramRouteCrudMapper.findAll();
        register(routes);
        MatcherUtils.setRouteRegistry(this);
    }
}
