package com.digiwin.dap.middle.ram.mapper;

import com.digiwin.dap.middle.ram.domain.GrantVO;
import com.digiwin.dap.middle.ram.domain.page.Page;
import com.digiwin.dap.middle.ram.domain.page.PageInfo;
import com.digiwin.dap.middle.ram.entity.Grant;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

@Repository
public interface RamGrantCrudMapper {

    int insert(@Param("entity") Grant entity);

    int deleteBySid(@Param("sid") long sid);

    int update(@Param("entity") Grant entity);

    Grant findBySid(@Param("sid") long sid);

    Grant findByTypeAndTarget(@Param("type") String type, @Param("targetId") String targetId);

    boolean existsBySid(@Param("sid") long sid);

    long countByPage(@Param("page") Page page);

    List<Grant> findByPage(@Param("page") PageInfo page);

    List<GrantVO> findByPage0(@Param("page") PageInfo page);
}
