package com.digiwin.dap.middle.ram.mapper;

import com.digiwin.dap.middle.ram.domain.GrantVO;
import com.digiwin.dap.middle.ram.domain.PolicyVO;
import com.digiwin.dap.middle.ram.domain.page.Page;
import com.digiwin.dap.middle.ram.domain.page.PageInfo;
import com.digiwin.dap.middle.ram.entity.GrantPolicy;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

@Repository
public interface RamGrantPolicyCrudMapper {

    int insert(@Param("entity") GrantPolicy entity);

    int deleteBySid(@Param("sid") long sid);

    int deleteByGrantSid(@Param("grantSid") long grantSid);

    List<GrantVO> findByPolicySid(@Param("policySid") long policySid);

    List<PolicyVO> findByGrantSid(@Param("grantSid") long grantSid);

    long countByPage(@Param("page") Page page);

    List<GrantVO> findByPage(@Param("page") PageInfo page);

    boolean exists(@Param("grantSid") long grantSid, @Param("policySid") long policySid);
    
    List<GrantPolicy> getByPolicySid(@Param("policySid") long policySid);
}
