package com.digiwin.dap.middle.ram.mapper;

import com.digiwin.dap.middle.ram.domain.PolicyVO;
import com.digiwin.dap.middle.ram.domain.RouteVO;
import com.digiwin.dap.middle.ram.domain.page.Page;
import com.digiwin.dap.middle.ram.domain.page.PageInfo;
import com.digiwin.dap.middle.ram.entity.Route;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

@Repository
public interface RamRouteCrudMapper {

    int insert(@Param("entity") Route entity);

    int deleteBySid(@Param("sid") long sid);

    int update(@Param("entity") Route entity);

    Route findBySid(@Param("sid") long sid);

    boolean existsBySid(@Param("sid") long sid);

    long countByPage(@Param("page") Page page);

    List<Route> findByPage(@Param("page") PageInfo page);

    List<RouteVO> findByPageCount(@Param("page") PageInfo page);

    List<Route> findAll();
}
