package com.digiwin.dap.middle.ram.service;

import com.digiwin.dap.middle.ram.constant.CacheConstant;
import com.digiwin.dap.middle.ram.domain.GrantPolicyVO;
import com.digiwin.dap.middle.ram.domain.PolicyRouteVO;
import com.digiwin.dap.middle.ram.domain.enums.PolicyType;
import com.digiwin.dap.middle.ram.mapper.RamCacheMapper;
import com.digiwin.dap.middleware.cache.RedisUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Set;

@Service
public class CacheHandlerService {

    @Value("${spring.application.name:dap}")
    private String appName;

    @Autowired
    private RamCacheMapper ramCacheMapper;

    public void grantChanged(String targetType, String targetId) {
        Set<String> keys = RedisUtils.keys(CacheConstant.getGrantTarget(appName, "*", targetType, targetId));
        keys.forEach(RedisUtils::delete);
    }

    public void policyChanged(String policyType, String policyId) {
        RedisUtils.delete(CacheConstant.getPolicyId(appName, policyType, policyId));
    }

    public void routeChanged(long routeSid) {
        List<PolicyRouteVO> caches = ramCacheMapper.findPolicyRouteByRouteSid(routeSid);
        for (PolicyRouteVO cache : caches) {
            handleCache(cache);
        }
    }

    public void policyRouteChanged(long policyRouteSid) {
        PolicyRouteVO cache = ramCacheMapper.findPolicyRouteBySid(policyRouteSid);
        if (cache == null) {
            return;
        }
        handleCache(cache);
    }

    public void grantPolicyChanged(long policyRouteSid) {
        GrantPolicyVO cache = ramCacheMapper.findGrantPolicyBySid(policyRouteSid);
        if (cache == null) {
            return;
        }
        handleCache(cache);
    }

    private void handleCache(PolicyRouteVO cache) {
        if (PolicyType.None.name().equals(cache.getPolicyType()) || PolicyType.AllowList.name()
                .equals(cache.getPolicyType()) || PolicyType.BlockList.name().equals(cache.getPolicyType())) {
            RedisUtils.delete(CacheConstant.getPolicyType(appName, cache.getPolicyType()));
        } else if (PolicyType.Base.name().equals(cache.getPolicyType())) {
            RedisUtils.delete(CacheConstant.getPolicyId(appName, cache.getPolicyType(), cache.getPolicyId()));
        } else if (PolicyType.Function.name().equals(cache.getPolicyType()) || PolicyType.Obsolete.name()
                .equals(cache.getPolicyType())) {
            RedisUtils.delete(CacheConstant.getPolicyPath(appName, cache.getPolicyType(), cache.getMethod(), cache.getPath()));
        }
    }

    private void handleCache(GrantPolicyVO cache) {
        if (PolicyType.AllowList.name().equals(cache.getPolicyType())
                || PolicyType.BlockList.name().equals(cache.getPolicyType())
                || PolicyType.Base.name().equals(cache.getPolicyType())
                || PolicyType.NoAuthApp.name().equals(cache.getPolicyType())
                || PolicyType.NoAuthUser.name().equals(cache.getPolicyType())
        ) {
            RedisUtils.delete(CacheConstant.getGrantTarget(appName, cache.getPolicyType(), cache.getTargetType(), cache.getTargetId()));
        }
    }
}
