package com.digiwin.dap.middle.ram.service;

import com.digiwin.dap.middle.ram.domain.TargetInfo;
import com.digiwin.dap.middle.ram.domain.enums.PolicyType;
import com.digiwin.dap.middle.ram.domain.enums.ResultType;
import com.digiwin.dap.middle.ram.domain.enums.TargetType;
import com.digiwin.dap.middle.ram.service.policy.PolicyHandler;

import javax.servlet.http.HttpServletRequest;
import java.util.List;

/**
 * 按照顺序执行 {@link TargetType}
 * <ol>
 *     <li>不控制 {@link PolicyType#None} 该策略下的API不做控制</li>
 *     <li>白名单 {@link PolicyType#AllowList} 设定了目标权限才可以访问</li>
 *     <li>黑名单 {@link PolicyType#BlockList} 空实现</li>
 *     <li>标准策略 {@link PolicyType#Base} <b>EFFECT属性：</b>0-拒绝访问，1-允许访问</li>
 *     <li>功能权限 {@link PolicyType#Function} 和IAM功能权限绑定，同时传递userToken、appToken才生效</li>
 *     <li>废弃拦截 {@link PolicyType#Obsolete} 禁止访问已废弃的API</li>
 * </ol>
 *
 * @author fobgo
 * @date 2021/9/18 17:58
 */
public final class PolicyTypeChain {

    private final List<? extends PolicyHandler> policyHandlers;
    private final int size;
    private int currentPosition = 0;

    public PolicyTypeChain(List<? extends PolicyHandler> policyHandlers) {
        this.policyHandlers = policyHandlers;
        this.size = policyHandlers.size();
    }

    public ResultType doNextStep(TargetInfo targetInfo, HttpServletRequest request) {
        if (currentPosition == size) {
            return ResultType.IMPLICIT_DENY;
        } else {
            currentPosition++;

            PolicyHandler nextPolicyHandler = policyHandlers.get(currentPosition - 1);

            ResultType resultType = nextPolicyHandler.matches(targetInfo, request);
            if (ResultType.IMPLICIT_DENY == resultType) {
                return doNextStep(targetInfo, request);
            } else {
                return resultType;
            }
        }
    }
}
