package com.digiwin.dap.middle.ram.service;

import com.digiwin.dap.middle.ram.domain.TargetInfo;
import com.digiwin.dap.middle.ram.domain.enums.ResultType;
import com.digiwin.dap.middle.ram.domain.enums.TargetType;
import com.digiwin.dap.middle.ram.service.policy.filiter.PolicyFilterHandler;

import javax.servlet.http.HttpServletRequest;
import java.util.List;

/**
 * 按照顺序执行 {@link TargetType}
 *
 * @author fobgo
 * @date 2021/9/18 17:58
 */
public final class TargetTypeChain {

    private final List<TargetType> targetTypes;
    private final int size;
    private final PolicyFilterHandler policyFilterHandler;
    private int currentPosition = 0;

    private TargetTypeChain(PolicyFilterHandler policyFilterHandler, List<TargetType> targetTypes) {
        this.policyFilterHandler = policyFilterHandler;
        this.targetTypes = targetTypes;
        this.size = targetTypes.size();
    }

    public static TargetTypeChain getInstance(PolicyFilterHandler policyHandler, List<TargetType> targetTypes) {
        return new TargetTypeChain(policyHandler, targetTypes);
    }

    public ResultType matches(TargetInfo targetInfo, HttpServletRequest request) {
        if (currentPosition == size) {
            return ResultType.IMPLICIT_DENY;
        } else {
            currentPosition++;

            TargetType nextTargetType = targetTypes.get(currentPosition - 1);

            ResultType resultType = policyFilterHandler.matches(nextTargetType.name(), targetInfo.obtain(nextTargetType), request);
            if (ResultType.IMPLICIT_DENY == resultType) {
                return matches(targetInfo, request);
            } else {
                return resultType;
            }
        }
    }
}
