package com.digiwin.dap.middle.ram.service.base;

import com.digiwin.dap.middle.ram.domain.page.Page;
import com.digiwin.dap.middle.ram.domain.page.PageData;
import com.digiwin.dap.middle.ram.entity.BaseEntity;

public interface RamBaseService<T extends BaseEntity> {

    /**
     * 新增数据
     *
     * @return 主键
     */
    long insert(T data);

    /**
     * 删除数据
     *
     * @param sid 主键
     * @return 删除成功数目 0或1
     */
    int deleteBySid(long sid);

    /**
     * 修改数据
     *
     * @return 主键
     */
    default long update(T data) {
        return 0;
    }

    /**
     * 查询数据
     *
     * @param sid 主键
     */
    default T findBySid(long sid) {
        return null;
    }

    /**
     * 数据是否存在
     *
     * @param sid 主键
     */
    default boolean existsBySid(long sid) {
        return Boolean.FALSE;
    }

    /**
     * 分页查询
     *
     * @param page 分页信息
     */
    default PageData<T> findByPage(Page page) {
        return PageData.empty();
    }
}
