package com.digiwin.dap.middle.ram.service.base;

import com.digiwin.dap.middle.ram.domain.GrantVO;
import com.digiwin.dap.middle.ram.domain.PolicyVO;
import com.digiwin.dap.middle.ram.domain.page.Page;
import com.digiwin.dap.middle.ram.domain.page.PageData;
import com.digiwin.dap.middle.ram.entity.Grant;
import com.digiwin.dap.middle.ram.mapper.RamGrantCrudMapper;
import com.digiwin.dap.middle.ram.util.BaseUtils;
import com.digiwin.dap.middleware.util.SnowFlake;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
public class RamGrantCrudService implements RamBaseService<Grant> {

    @Autowired
    private RamGrantCrudMapper ramGrantCrudMapper;

    @Override
    public long insert(Grant data) {
        data.setSid(SnowFlake.getInstance().newId());
        BaseUtils.setCreateFields(data);
        ramGrantCrudMapper.insert(data);
        return data.getSid();
    }

    @Override
    public int deleteBySid(long sid) {
        return ramGrantCrudMapper.deleteBySid(sid);
    }

    @Override
    public long update(Grant data) {
        BaseUtils.setCreateFields(data);
        ramGrantCrudMapper.update(data);
        return data.getSid();
    }

    @Override
    public Grant findBySid(long sid) {
        return ramGrantCrudMapper.findBySid(sid);
    }

    @Override
    public boolean existsBySid(long sid) {
        return ramGrantCrudMapper.existsBySid(sid);
    }

    @Override
    public PageData<Grant> findByPage(Page page) {
        long total = ramGrantCrudMapper.countByPage(page);
        if (total == 0) {
            return PageData.empty();
        }
        List<Grant> paths = ramGrantCrudMapper.findByPage(page.offsetPage());
        return PageData.data(total, paths);
    }

    public PageData<GrantVO> findByPage0(Page page) {
        long total = ramGrantCrudMapper.countByPage(page);
        if (total == 0) {
            return PageData.empty();
        }
        List<GrantVO> paths = ramGrantCrudMapper.findByPage0(page.offsetPage());
        return PageData.data(total, paths);
    }
}
