package com.digiwin.dap.middle.ram.service.base;

import com.digiwin.dap.middle.ram.domain.GrantVO;
import com.digiwin.dap.middle.ram.domain.PolicyVO;
import com.digiwin.dap.middle.ram.domain.page.Page;
import com.digiwin.dap.middle.ram.domain.page.PageData;
import com.digiwin.dap.middle.ram.entity.GrantPolicy;
import com.digiwin.dap.middle.ram.mapper.RamGrantPolicyCrudMapper;
import com.digiwin.dap.middle.ram.util.BaseUtils;
import com.digiwin.dap.middleware.util.SnowFlake;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
public class RamGrantPolicyCrudService implements RamBaseService<GrantPolicy> {

    @Autowired
    private RamGrantPolicyCrudMapper ramGrantPolicyCrudMapper;

    @Override
    public long insert(GrantPolicy data) {
        data.setSid(SnowFlake.getInstance().newId());
        BaseUtils.setCreateFields(data);
        ramGrantPolicyCrudMapper.insert(data);
        return data.getSid();
    }

    @Override
    public int deleteBySid(long sid) {
        return ramGrantPolicyCrudMapper.deleteBySid(sid);
    }

    public int deleteByGrantSid(long grantSid) {
        return ramGrantPolicyCrudMapper.deleteByGrantSid(grantSid);
    }

    public List<GrantVO> findByPolicySid(long policySid) {
        return ramGrantPolicyCrudMapper.findByPolicySid(policySid);
    }

    public List<PolicyVO> findByGrantSid(long grantSid) {
        return ramGrantPolicyCrudMapper.findByGrantSid(grantSid);
    }

    public PageData<GrantVO> findByPage0(Page page) {
        long total = ramGrantPolicyCrudMapper.countByPage(page);
        if (total == 0) {
            return PageData.empty();
        }
        List<GrantVO> paths = ramGrantPolicyCrudMapper.findByPage(page.offsetPage());
        return PageData.data(total, paths);
    }
}
