package com.digiwin.dap.middle.ram.service.base;

import com.digiwin.dap.middle.ram.domain.page.Page;
import com.digiwin.dap.middle.ram.domain.page.PageData;
import com.digiwin.dap.middle.ram.domain.PolicyVO;
import com.digiwin.dap.middle.ram.entity.Policy;
import com.digiwin.dap.middle.ram.mapper.RamPolicyCrudMapper;
import com.digiwin.dap.middle.ram.util.BaseUtils;
import com.digiwin.dap.middleware.util.SnowFlake;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
public class RamPolicyCrudService implements RamBaseService<Policy> {

    @Autowired
    private RamPolicyCrudMapper ramPolicyCrudMapper;

    @Override
    public long insert(Policy data) {
        data.setSid(SnowFlake.getInstance().newId());
        BaseUtils.setCreateFields(data);
        ramPolicyCrudMapper.insert(data);
        return data.getSid();
    }

    @Override
    public int deleteBySid(long sid) {
        return ramPolicyCrudMapper.deleteBySid(sid);
    }

    @Override
    public long update(Policy data) {
        BaseUtils.setCreateFields(data);
        ramPolicyCrudMapper.update(data);
        return data.getSid();
    }

    @Override
    public Policy findBySid(long sid) {
        return ramPolicyCrudMapper.findBySid(sid);
    }

    @Override
    public boolean existsBySid(long sid) {
        return ramPolicyCrudMapper.existsBySid(sid);
    }

    @Override
    public PageData<Policy> findByPage(Page page) {
        long total = ramPolicyCrudMapper.countByPage(page);
        if (total == 0) {
            return PageData.empty();
        }
        List<Policy> paths = ramPolicyCrudMapper.findByPage(page.offsetPage());
        return PageData.data(total, paths);
    }

    public PageData<PolicyVO> findByPage0(Page page) {
        long total = ramPolicyCrudMapper.countByPage(page);
        if (total == 0) {
            return PageData.empty();
        }
        List<PolicyVO> paths = ramPolicyCrudMapper.findByPage0(page.offsetPage());
        return PageData.data(total, paths);
    }
}
