package com.digiwin.dap.middle.ram.service.base;

import com.digiwin.dap.middle.ram.domain.PolicyVO;
import com.digiwin.dap.middle.ram.domain.RouteVO;
import com.digiwin.dap.middle.ram.entity.PolicyRoute;
import com.digiwin.dap.middle.ram.mapper.RamPolicyRouteCrudMapper;
import com.digiwin.dap.middle.ram.util.BaseUtils;
import com.digiwin.dap.middleware.util.SnowFlake;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
public class RamPolicyRouteCrudService implements RamBaseService<PolicyRoute> {

    @Autowired
    private RamPolicyRouteCrudMapper ramPolicyRouteCrudMapper;

    @Override
    public long insert(PolicyRoute data) {
        data.setSid(SnowFlake.getInstance().newId());
        BaseUtils.setCreateFields(data);
        ramPolicyRouteCrudMapper.insert(data);
        return data.getSid();
    }

    @Override
    public int deleteBySid(long sid) {
        return ramPolicyRouteCrudMapper.deleteBySid(sid);
    }

    public int deleteByPolicySid(long policySid) {
        return ramPolicyRouteCrudMapper.deleteByPolicySid(policySid);
    }

    public List<PolicyVO> findByRouteSid(long policySid) {
        return ramPolicyRouteCrudMapper.findByRouteSid(policySid);
    }

    public List<RouteVO> findByPolicySid(long routeSid) {
        return ramPolicyRouteCrudMapper.findByPolicySid(routeSid);
    }
}
